/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.jdbcbridge.internal.vertx.ext.web.handler.sockjs.impl;

import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.AsyncResult;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.Future;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.Handler;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.MultiMap;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.Vertx;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.buffer.Buffer;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.http.ServerWebSocket;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.net.SocketAddress;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.net.impl.ConnectionBase;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.streams.ReadStream;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.ext.auth.User;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.ext.web.Router;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.ext.web.Session;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.ext.web.handler.sockjs.SockJSSocket;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.ext.web.handler.sockjs.impl.BaseTransport;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.ext.web.handler.sockjs.impl.SockJSSocketBase;

class RawWebSocketTransport {
    RawWebSocketTransport(Vertx vertx, Router router, Handler<SockJSSocket> sockHandler) {
        String wsRE = "/websocket";
        router.get(wsRE).handler(rc -> {
            ServerWebSocket ws = rc.request().upgrade();
            RawWSSockJSSocket sock = new RawWSSockJSSocket(vertx, rc.session(), rc.user(), ws);
            sockHandler.handle(sock);
        });
        router.get(wsRE).handler(rc -> rc.response().setStatusCode(400).end("Can \"Upgrade\" only to \"WebSocket\"."));
        router.get(wsRE).handler(rc -> rc.response().putHeader("Allow", "GET").setStatusCode(405).end());
    }

    private static class RawWSSockJSSocket
    extends SockJSSocketBase {
        final ServerWebSocket ws;
        MultiMap headers;
        boolean closed;

        RawWSSockJSSocket(Vertx vertx, Session webSession, User webUser, ServerWebSocket ws) {
            super(vertx, webSession, webUser);
            this.ws = ws;
            ws.closeHandler(v -> {
                RawWSSockJSSocket rawWSSockJSSocket = this;
                synchronized (rawWSSockJSSocket) {
                    this.closed = true;
                }
                RawWSSockJSSocket.super.close();
            });
        }

        @Override
        public SockJSSocket handler(Handler<Buffer> handler) {
            this.ws.binaryMessageHandler(handler);
            this.ws.textMessageHandler(textMessage -> handler.handle(Buffer.buffer(textMessage)));
            return this;
        }

        @Override
        public SockJSSocket pause() {
            this.ws.pause();
            return this;
        }

        @Override
        public SockJSSocket resume() {
            this.ws.resume();
            return this;
        }

        @Override
        public ReadStream<Buffer> fetch(long amount) {
            this.ws.fetch(amount);
            return this;
        }

        private synchronized boolean canWrite(Handler<AsyncResult<Void>> handler) {
            if (this.closed) {
                if (handler != null) {
                    this.vertx.runOnContext(v -> handler.handle(Future.failedFuture(ConnectionBase.CLOSED_EXCEPTION)));
                }
                return false;
            }
            return true;
        }

        @Override
        public SockJSSocket write(Buffer data, Handler<AsyncResult<Void>> handler) {
            if (this.canWrite(handler)) {
                this.ws.writeBinaryMessage(data, (Handler)handler);
            }
            return this;
        }

        @Override
        public SockJSSocket write(String data, Handler<AsyncResult<Void>> handler) {
            if (this.canWrite(handler)) {
                this.ws.writeTextMessage(data, (Handler)handler);
            }
            return this;
        }

        @Override
        public SockJSSocket setWriteQueueMaxSize(int maxQueueSize) {
            this.ws.setWriteQueueMaxSize(maxQueueSize);
            return this;
        }

        @Override
        public boolean writeQueueFull() {
            return this.ws.writeQueueFull();
        }

        @Override
        public SockJSSocket drainHandler(Handler<Void> handler) {
            this.ws.drainHandler((Handler)handler);
            return this;
        }

        @Override
        public SockJSSocket exceptionHandler(Handler<Throwable> handler) {
            this.ws.exceptionHandler((Handler)handler);
            return this;
        }

        @Override
        public SockJSSocket endHandler(Handler<Void> endHandler) {
            this.ws.endHandler((Handler)endHandler);
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            RawWSSockJSSocket rawWSSockJSSocket = this;
            synchronized (rawWSSockJSSocket) {
                if (this.closed) {
                    return;
                }
                this.closed = true;
            }
            super.close();
            this.ws.close();
        }

        @Override
        public void closeAfterSessionExpired() {
            this.close(1001, "Session expired");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close(int statusCode, String reason) {
            RawWSSockJSSocket rawWSSockJSSocket = this;
            synchronized (rawWSSockJSSocket) {
                if (this.closed) {
                    return;
                }
                this.closed = true;
            }
            super.close();
            this.ws.close((short)statusCode, reason);
        }

        @Override
        public SocketAddress remoteAddress() {
            return this.ws.remoteAddress();
        }

        @Override
        public SocketAddress localAddress() {
            return this.ws.localAddress();
        }

        @Override
        public MultiMap headers() {
            if (this.headers == null) {
                this.headers = BaseTransport.removeCookieHeaders(this.ws.headers());
            }
            return this.headers;
        }

        @Override
        public String uri() {
            return this.ws.uri();
        }
    }
}

