/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.jdbcbridge.internal.vertx.ext.web.handler.sockjs.impl;

import java.util.UUID;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.AsyncResult;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.Handler;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.Vertx;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.buffer.Buffer;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.eventbus.Message;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.eventbus.MessageConsumer;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.ext.auth.User;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.ext.web.Session;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.ext.web.handler.sockjs.SockJSSocket;

public abstract class SockJSSocketBase
implements SockJSSocket {
    private final MessageConsumer<Buffer> registration;
    protected final Vertx vertx;
    protected Session webSession;
    protected User webUser;
    private final String writeHandlerID;

    @Override
    public abstract SockJSSocket exceptionHandler(Handler<Throwable> var1);

    protected SockJSSocketBase(Vertx vertx, Session webSession, User webUser) {
        this.vertx = vertx;
        this.webSession = webSession;
        this.webUser = webUser;
        Handler<Message> writeHandler = buff -> this.write((Buffer)buff.body());
        this.writeHandlerID = UUID.randomUUID().toString();
        this.registration = vertx.eventBus().consumer(this.writeHandlerID).handler(writeHandler);
    }

    @Override
    public String writeHandlerID() {
        return this.writeHandlerID;
    }

    @Override
    public void end() {
        this.registration.unregister();
    }

    @Override
    public void end(Handler<AsyncResult<Void>> handler) {
        this.registration.unregister(handler);
    }

    @Override
    public void close() {
        this.end();
    }

    public void closeAfterSessionExpired() {
        this.close();
    }

    @Override
    public Session webSession() {
        return this.webSession;
    }

    @Override
    public User webUser() {
        return this.webUser;
    }
}

