/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.jdbcbridge.internal.vertx.ext.web.handler.sockjs.impl;

import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.AsyncResult;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.Handler;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.Vertx;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.buffer.Buffer;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.http.HttpServerRequest;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.http.HttpServerResponse;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.http.HttpVersion;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.logging.Logger;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.logging.LoggerFactory;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.shareddata.LocalMap;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.ext.web.Router;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.ext.web.RoutingContext;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.ext.web.handler.sockjs.SockJSHandlerOptions;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.ext.web.handler.sockjs.SockJSSocket;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.ext.web.handler.sockjs.impl.BaseTransport;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.ext.web.handler.sockjs.impl.SockJSSession;

class XhrTransport
extends BaseTransport {
    private static final Logger log = LoggerFactory.getLogger(XhrTransport.class);
    private static final Buffer H_BLOCK;

    XhrTransport(Vertx vertx, Router router, LocalMap<String, SockJSSession> sessions, SockJSHandlerOptions options, Handler<SockJSSocket> sockHandler) {
        super(vertx, sessions, options);
        String xhrBase = "\\/[^\\/\\.]+\\/([^\\/\\.]+)\\/";
        String xhrRE = xhrBase + "xhr";
        String xhrStreamRE = xhrBase + "xhr_streaming";
        Handler<RoutingContext> xhrOptionsHandler = XhrTransport.createCORSOptionsHandler(options, "OPTIONS, POST");
        router.optionsWithRegex(xhrRE).handler(xhrOptionsHandler);
        router.optionsWithRegex(xhrStreamRE).handler(xhrOptionsHandler);
        this.registerHandler(router, sockHandler, xhrRE, false, options);
        this.registerHandler(router, sockHandler, xhrStreamRE, true, options);
        String xhrSendRE = "\\/[^\\/\\.]+\\/([^\\/\\.]+)\\/xhr_send";
        router.optionsWithRegex(xhrSendRE).handler(xhrOptionsHandler);
        router.postWithRegex(xhrSendRE).handler(rc -> {
            String sessionID;
            SockJSSession session;
            if (log.isTraceEnabled()) {
                log.trace("XHR send, post, " + rc.request().uri());
            }
            if ((session = (SockJSSession)sessions.get(sessionID = rc.request().getParam("param0"))) != null && !session.isClosed()) {
                this.handleSend((RoutingContext)rc, session);
            } else {
                rc.response().setStatusCode(404);
                XhrTransport.setJSESSIONID(options, rc);
                rc.response().end();
            }
        });
    }

    private void registerHandler(Router router, Handler<SockJSSocket> sockHandler, String re, boolean streaming, SockJSHandlerOptions options) {
        router.postWithRegex(re).handler(rc -> {
            if (log.isTraceEnabled()) {
                log.trace("XHR, post, " + rc.request().uri());
            }
            XhrTransport.setNoCacheHeaders(rc);
            String sessionID = rc.request().getParam("param0");
            SockJSSession session = this.getSession((RoutingContext)rc, options.getSessionTimeout(), options.getHeartbeatInterval(), sessionID, sockHandler);
            HttpServerRequest req = rc.request();
            session.register(req, streaming ? new XhrStreamingListener(options.getMaxBytesStreaming(), (RoutingContext)rc, session) : new XhrPollingListener((RoutingContext)rc, session));
        });
    }

    private void handleSend(RoutingContext rc, SockJSSession session) {
        Buffer body = rc.getBody();
        if (body != null) {
            this.handleSendMessage(rc, session, body);
        } else if (rc.request().isEnded()) {
            log.error("Request ended before SockJS handler could read the body. Do you have an asynchronous request handler before the SockJS handler? If so, add a BodyHandler before the SockJS handler (see the docs).");
            rc.fail(500);
        } else {
            rc.request().bodyHandler(buff -> this.handleSendMessage(rc, session, (Buffer)buff));
        }
    }

    private void handleSendMessage(RoutingContext rc, SockJSSession session, Buffer body) {
        String msgs = body.toString();
        if (msgs.equals("")) {
            rc.response().setStatusCode(500);
            rc.response().end("Payload expected.");
            return;
        }
        if (!session.handleMessages(msgs)) {
            this.sendInvalidJSON(rc.response());
        } else {
            rc.response().putHeader("Content-Type", "text/plain; charset=UTF-8");
            XhrTransport.setNoCacheHeaders(rc);
            XhrTransport.setJSESSIONID(this.options, rc);
            XhrTransport.setCORS(rc);
            rc.response().setStatusCode(204);
            rc.response().end();
        }
        if (log.isTraceEnabled()) {
            log.trace("XHR send processed ok");
        }
    }

    static {
        byte[] bytes = new byte[2049];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = 104;
        }
        bytes[bytes.length - 1] = 10;
        H_BLOCK = Buffer.buffer(bytes);
    }

    private class XhrStreamingListener
    extends BaseXhrListener {
        int bytesSent;
        int maxBytesStreaming;

        XhrStreamingListener(int maxBytesStreaming, RoutingContext rc, SockJSSession session) {
            super(rc, session);
            this.maxBytesStreaming = maxBytesStreaming;
            this.addCloseHandler(rc.response(), session);
        }

        @Override
        public void sendFrame(String body, Handler<AsyncResult<Void>> handler) {
            boolean hr = this.headersWritten;
            super.beforeSend();
            if (!hr) {
                this.rc.response().write(H_BLOCK);
            }
            String sbody = body + "\n";
            Buffer buff = Buffer.buffer(sbody);
            this.rc.response().write(buff, handler);
            this.bytesSent += buff.length();
            if (this.bytesSent >= this.maxBytesStreaming) {
                this.close();
            }
        }

        @Override
        public void close() {
            if (log.isTraceEnabled()) {
                log.trace("XHR stream closing listener");
            }
            if (!this.closed) {
                this.session.resetListener();
                try {
                    this.rc.response().end();
                    this.rc.response().close();
                    this.closed = true;
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }
        }
    }

    private class XhrPollingListener
    extends BaseXhrListener {
        XhrPollingListener(RoutingContext rc, SockJSSession session) {
            super(rc, session);
            this.addCloseHandler(rc.response(), session);
        }

        @Override
        public void sendFrame(String body, Handler<AsyncResult<Void>> handler) {
            super.beforeSend();
            this.rc.response().write(body + "\n", handler);
            this.close();
        }

        @Override
        public void close() {
            if (log.isTraceEnabled()) {
                log.trace("XHR poll closing listener");
            }
            if (!this.closed) {
                try {
                    this.session.resetListener();
                    this.rc.response().end();
                    this.rc.response().close();
                    this.closed = true;
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }
        }
    }

    private abstract class BaseXhrListener
    extends BaseTransport.BaseListener {
        boolean headersWritten;

        BaseXhrListener(RoutingContext rc, SockJSSession session) {
            super(rc, session);
        }

        final void beforeSend() {
            if (log.isTraceEnabled()) {
                log.trace("XHR sending frame");
            }
            if (!this.headersWritten) {
                HttpServerResponse resp = this.rc.response();
                resp.putHeader("Content-Type", "application/javascript; charset=UTF-8");
                BaseTransport.setJSESSIONID(XhrTransport.this.options, this.rc);
                BaseTransport.setCORS(this.rc);
                if (this.rc.request().version() != HttpVersion.HTTP_1_0) {
                    resp.setChunked(true);
                }
                this.headersWritten = true;
            }
        }

        @Override
        public void close() {
        }
    }
}

