/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.jdbcbridge.internal.vertx.ext.web.impl;

import java.util.LinkedHashMap;
import java.util.Map;

public class LRUCache<K, V>
extends LinkedHashMap<K, V> {
    private final int maxSize;

    public LRUCache(int initialCapacity, float loadFactor, int maxSize) {
        super(initialCapacity, loadFactor);
        this.maxSize = maxSize;
        this.checkSize();
    }

    public LRUCache(int initialCapacity, int maxSize) {
        super(initialCapacity);
        this.maxSize = maxSize;
        this.checkSize();
    }

    public LRUCache(int maxSize) {
        this.maxSize = maxSize;
        this.checkSize();
    }

    public LRUCache(Map<? extends K, ? extends V> m3, int maxSize) {
        super(m3);
        this.maxSize = maxSize;
        this.checkSize();
    }

    public LRUCache(int initialCapacity, float loadFactor, boolean accessOrder, int maxSize) {
        super(initialCapacity, loadFactor, accessOrder);
        this.maxSize = maxSize;
        this.checkSize();
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
        return this.size() > this.maxSize;
    }

    private void checkSize() {
        if (this.maxSize < 1) {
            throw new IllegalArgumentException("maxSize must be >= 1");
        }
    }
}

