/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.jdbcbridge.internal.vertx.ext.web.impl;

import ru.yandex.clickhouse.jdbcbridge.internal.vertx.ext.web.MIMEHeader;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.ext.web.impl.HeaderParser;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.ext.web.impl.ParsableHeaderValue;

public class ParsableMIMEValue
extends ParsableHeaderValue
implements MIMEHeader {
    private String component = null;
    private String subComponent = null;
    private int orderWeight;

    public ParsableMIMEValue(String headerContent) {
        super(headerContent);
    }

    @Override
    public String component() {
        return this.component;
    }

    @Override
    public String subComponent() {
        return this.subComponent;
    }

    @Override
    protected boolean isMatchedBy2(ParsableHeaderValue matchTry) {
        ParsableMIMEValue myMatchTry = (ParsableMIMEValue)matchTry;
        this.ensureHeaderProcessed();
        if (!("*".equals(this.component) || "*".equals(myMatchTry.component) || this.component.equals(myMatchTry.component))) {
            return false;
        }
        if (!("*".equals(this.subComponent) || "*".equals(myMatchTry.subComponent) || this.subComponent.equals(myMatchTry.subComponent))) {
            return false;
        }
        if ("*".equals(this.component) && "*".equals(this.subComponent) && this.parameters().size() == 0) {
            return true;
        }
        return super.isMatchedBy2(myMatchTry);
    }

    @Override
    protected void ensureHeaderProcessed() {
        super.ensureHeaderProcessed();
        if (this.component == null) {
            HeaderParser.parseMIME(this.value, this::setComponent, this::setSubComponent);
            this.orderWeight = "*".equals(this.component) ? 0 : 1;
            this.orderWeight += "*".equals(this.subComponent) ? 0 : 2;
        }
    }

    @Override
    public ParsableMIMEValue forceParse() {
        this.ensureHeaderProcessed();
        return this;
    }

    private void setComponent(String component) {
        this.component = "*".equals(component) ? "*" : component;
    }

    private void setSubComponent(String subComponent) {
        this.subComponent = "*".equals(subComponent) ? "*" : subComponent;
    }

    @Override
    protected int weightedOrderPart2() {
        return this.orderWeight;
    }
}

