/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.jdbcbridge.internal.vertx.ext.web.sstore.impl;

import java.util.HashSet;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.AsyncResult;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.Future;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.Handler;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.Vertx;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.json.JsonObject;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.shareddata.LocalMap;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.ext.auth.PRNG;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.ext.web.Session;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.ext.web.sstore.AbstractSession;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.ext.web.sstore.LocalSessionStore;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.ext.web.sstore.SessionStore;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.ext.web.sstore.impl.SharedDataSessionImpl;

public class LocalSessionStoreImpl
implements SessionStore,
LocalSessionStore,
Handler<Long> {
    private static final long DEFAULT_REAPER_INTERVAL = 1000L;
    private static final String DEFAULT_SESSION_MAP_NAME = "vertx-web.sessions";
    private LocalMap<String, Session> localMap;
    private long reaperInterval;
    private PRNG random;
    private long timerID = -1L;
    private boolean closed;
    protected Vertx vertx;

    @Override
    public Session createSession(long timeout) {
        return new SharedDataSessionImpl(this.random, timeout, 16);
    }

    @Override
    public Session createSession(long timeout, int length) {
        return new SharedDataSessionImpl(this.random, timeout, length);
    }

    @Override
    public SessionStore init(Vertx vertx, JsonObject options) {
        this.random = new PRNG(vertx);
        this.vertx = vertx;
        this.reaperInterval = options.getLong("reaperInterval", 1000L);
        this.localMap = vertx.sharedData().getLocalMap(options.getString("mapName", DEFAULT_SESSION_MAP_NAME));
        this.setTimer();
        return this;
    }

    @Override
    public long retryTimeout() {
        return 0L;
    }

    @Override
    public void get(String id, Handler<AsyncResult<Session>> resultHandler) {
        resultHandler.handle(Future.succeededFuture(this.localMap.get(id)));
    }

    @Override
    public void delete(String id, Handler<AsyncResult<Void>> resultHandler) {
        this.localMap.remove(id);
        resultHandler.handle(Future.succeededFuture());
    }

    @Override
    public void put(Session session, Handler<AsyncResult<Void>> resultHandler) {
        AbstractSession oldSession = (AbstractSession)this.localMap.get(session.id());
        AbstractSession newSession = (AbstractSession)session;
        if (oldSession != null && oldSession.version() != newSession.version()) {
            resultHandler.handle(Future.failedFuture("Version mismatch"));
            return;
        }
        newSession.incrementVersion();
        this.localMap.put(session.id(), session);
        resultHandler.handle(Future.succeededFuture());
    }

    @Override
    public void clear(Handler<AsyncResult<Void>> resultHandler) {
        this.localMap.clear();
        resultHandler.handle(Future.succeededFuture());
    }

    @Override
    public void size(Handler<AsyncResult<Integer>> resultHandler) {
        resultHandler.handle(Future.succeededFuture(this.localMap.size()));
    }

    @Override
    public synchronized void close() {
        this.localMap.close();
        if (this.timerID != -1L) {
            this.vertx.cancelTimer(this.timerID);
        }
        this.random.close();
        this.closed = true;
    }

    @Override
    public synchronized void handle(Long tid) {
        long now = System.currentTimeMillis();
        HashSet<String> toRemove = new HashSet<String>();
        for (Session session : this.localMap.values()) {
            if (now - session.lastAccessed() <= session.timeout()) continue;
            toRemove.add(session.id());
        }
        for (String id : toRemove) {
            this.localMap.remove(id);
        }
        if (!this.closed) {
            this.setTimer();
        }
    }

    private void setTimer() {
        if (this.reaperInterval != 0L) {
            this.timerID = this.vertx.setTimer(this.reaperInterval, this);
        }
    }
}

