/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.jdbcbridge.internal.vertx.micrometer;

import java.time.Duration;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.influx.InfluxConfig;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.codegen.annotations.DataObject;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.json.JsonObject;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.micrometer.VertxInfluxDbOptionsConverter;

@DataObject(generateConverter=true, inheritConverter=true)
public class VertxInfluxDbOptions {
    public static final boolean DEFAULT_ENABLED = false;
    public static final int DEFAULT_STEP = 10;
    public static final int DEFAULT_BATCH_SIZE = 10000;
    public static final String DEFAULT_URI = "http://localhost:8086";
    public static final String DEFAULT_DATABASE = "default";
    public static final boolean DEFAULT_COMPRESSION_ENABLED = true;
    public static final int DEFAULT_NUM_THREADS = 2;
    public static final int DEFAULT_CONNECT_TIMEOUT = 1;
    public static final int DEFAULT_READ_TIMEOUT = 10;
    private boolean enabled;
    private String uri;
    private String db;
    private String userName;
    private String password;
    private String retentionPolicy;
    private boolean compressed;
    private int step;
    private int numThreads;
    private int connectTimeout;
    private int readTimeout;
    private int batchSize;

    public VertxInfluxDbOptions() {
        this.enabled = false;
        this.uri = DEFAULT_URI;
        this.db = DEFAULT_DATABASE;
        this.compressed = true;
        this.step = 10;
        this.numThreads = 2;
        this.connectTimeout = 1;
        this.readTimeout = 10;
        this.batchSize = 10000;
    }

    public VertxInfluxDbOptions(VertxInfluxDbOptions other) {
        this.enabled = other.enabled;
        this.uri = other.uri;
        this.db = other.db;
        this.userName = other.userName;
        this.password = other.password;
        this.retentionPolicy = other.retentionPolicy;
        this.compressed = other.compressed;
        this.step = other.step;
        this.numThreads = other.numThreads;
        this.connectTimeout = other.connectTimeout;
        this.readTimeout = other.readTimeout;
        this.batchSize = other.batchSize;
    }

    public VertxInfluxDbOptions(JsonObject json) {
        this();
        VertxInfluxDbOptionsConverter.fromJson(json, this);
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        VertxInfluxDbOptionsConverter.toJson(this, json);
        return json;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public VertxInfluxDbOptions setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public String getUri() {
        return this.uri;
    }

    public VertxInfluxDbOptions setUri(String uri) {
        this.uri = uri;
        return this;
    }

    public String getDb() {
        return this.db;
    }

    public VertxInfluxDbOptions setDb(String db) {
        this.db = db;
        return this;
    }

    public String getUserName() {
        return this.userName;
    }

    public VertxInfluxDbOptions setUserName(String userName) {
        this.userName = userName;
        return this;
    }

    public String getPassword() {
        return this.password;
    }

    public VertxInfluxDbOptions setPassword(String password) {
        this.password = password;
        return this;
    }

    public String getRetentionPolicy() {
        return this.retentionPolicy;
    }

    public VertxInfluxDbOptions setRetentionPolicy(String retentionPolicy) {
        this.retentionPolicy = retentionPolicy;
        return this;
    }

    public boolean isCompressed() {
        return this.compressed;
    }

    public VertxInfluxDbOptions setCompressed(boolean compressed) {
        this.compressed = compressed;
        return this;
    }

    public int getStep() {
        return this.step;
    }

    public VertxInfluxDbOptions setStep(int step) {
        this.step = step;
        return this;
    }

    public int getNumThreads() {
        return this.numThreads;
    }

    public VertxInfluxDbOptions setNumThreads(int numThreads) {
        this.numThreads = numThreads;
        return this;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public VertxInfluxDbOptions setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
        return this;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public VertxInfluxDbOptions setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
        return this;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public VertxInfluxDbOptions setBatchSize(int batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    public InfluxConfig toMicrometerConfig() {
        return new InfluxConfig(){

            public String get(String k) {
                return null;
            }

            public String db() {
                return VertxInfluxDbOptions.this.db;
            }

            public String userName() {
                return VertxInfluxDbOptions.this.userName;
            }

            public String password() {
                return VertxInfluxDbOptions.this.password;
            }

            public String retentionPolicy() {
                return VertxInfluxDbOptions.this.retentionPolicy;
            }

            public String uri() {
                return VertxInfluxDbOptions.this.uri;
            }

            public boolean compressed() {
                return VertxInfluxDbOptions.this.compressed;
            }

            public Duration step() {
                return Duration.ofSeconds(VertxInfluxDbOptions.this.step);
            }

            public int numThreads() {
                return VertxInfluxDbOptions.this.numThreads;
            }

            public Duration connectTimeout() {
                return Duration.ofSeconds(VertxInfluxDbOptions.this.connectTimeout);
            }

            public Duration readTimeout() {
                return Duration.ofSeconds(VertxInfluxDbOptions.this.readTimeout);
            }

            public int batchSize() {
                return VertxInfluxDbOptions.this.batchSize;
            }
        };
    }
}

