/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.jdbcbridge.internal.vertx.micrometer;

import java.time.Duration;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.jmx.JmxConfig;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.codegen.annotations.DataObject;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.json.JsonObject;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.micrometer.VertxJmxMetricsOptionsConverter;

@DataObject(generateConverter=true, inheritConverter=true)
public class VertxJmxMetricsOptions {
    public static final boolean DEFAULT_ENABLED = false;
    public static final String DEFAULT_DOMAIN = "metrics";
    public static final int DEFAULT_STEP = 10;
    private boolean enabled;
    private String domain;
    private int step;

    public VertxJmxMetricsOptions() {
        this.enabled = false;
        this.domain = DEFAULT_DOMAIN;
        this.step = 10;
    }

    public VertxJmxMetricsOptions(VertxJmxMetricsOptions other) {
        this.enabled = other.enabled;
        this.domain = other.domain;
        this.step = other.step;
    }

    public VertxJmxMetricsOptions(JsonObject json) {
        this();
        VertxJmxMetricsOptionsConverter.fromJson(json, this);
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        VertxJmxMetricsOptionsConverter.toJson(this, json);
        return json;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public VertxJmxMetricsOptions setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public String getDomain() {
        return this.domain;
    }

    public VertxJmxMetricsOptions setDomain(String domain) {
        this.domain = domain;
        return this;
    }

    public int getStep() {
        return this.step;
    }

    public VertxJmxMetricsOptions setStep(int step) {
        this.step = step;
        return this;
    }

    public JmxConfig toMicrometerConfig() {
        return new JmxConfig(){

            public String get(String s2) {
                return null;
            }

            public String domain() {
                return VertxJmxMetricsOptions.this.domain;
            }

            public Duration step() {
                return Duration.ofSeconds(VertxJmxMetricsOptions.this.step);
            }
        };
    }
}

