/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.jdbcbridge.internal.vertx.micrometer.backends;

import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.regex.Pattern;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.Meter;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.MeterRegistry;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.config.MeterFilter;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.prometheus.PrometheusMeterRegistry;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.micrometer.Label;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.micrometer.Match;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.micrometer.MetricsDomain;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.micrometer.MicrometerMetricsOptions;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.micrometer.backends.BackendRegistry;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.micrometer.backends.InfluxDbBackendRegistry;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.micrometer.backends.JmxBackendRegistry;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.micrometer.backends.NoopBackendRegistry;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.micrometer.backends.PrometheusBackendRegistry;

public final class BackendRegistries {
    private static final Map<String, BackendRegistry> REGISTRIES = new ConcurrentHashMap<String, BackendRegistry>();

    private BackendRegistries() {
    }

    public static BackendRegistry setupBackend(MicrometerMetricsOptions options) {
        return REGISTRIES.computeIfAbsent(options.getRegistryName(), k -> {
            BackendRegistry reg = options.getMicrometerRegistry() != null ? (options.getPrometheusOptions() != null && options.getMicrometerRegistry() instanceof PrometheusMeterRegistry ? new PrometheusBackendRegistry(options.getPrometheusOptions(), (PrometheusMeterRegistry)options.getMicrometerRegistry()) : options::getMicrometerRegistry) : (options.getInfluxDbOptions() != null && options.getInfluxDbOptions().isEnabled() ? new InfluxDbBackendRegistry(options.getInfluxDbOptions()) : (options.getPrometheusOptions() != null && options.getPrometheusOptions().isEnabled() ? new PrometheusBackendRegistry(options.getPrometheusOptions()) : (options.getJmxMetricsOptions() != null && options.getJmxMetricsOptions().isEnabled() ? new JmxBackendRegistry(options.getJmxMetricsOptions()) : NoopBackendRegistry.INSTANCE)));
            BackendRegistries.registerMatchers(reg.getMeterRegistry(), options.getLabels(), options.getLabelMatches());
            return reg;
        });
    }

    public static MeterRegistry getDefaultNow() {
        return BackendRegistries.getNow("default");
    }

    public static MeterRegistry getNow(String registryName) {
        BackendRegistry backendRegistry = REGISTRIES.get(registryName);
        if (backendRegistry != null) {
            return backendRegistry.getMeterRegistry();
        }
        return null;
    }

    public static void stop(String registryName) {
        BackendRegistry reg = REGISTRIES.remove(registryName);
        if (reg != null) {
            reg.close();
        }
    }

    public static void registerMatchers(MeterRegistry registry, Set<Label> enabledLabels, List<Match> matches) {
        String[] ignored = (String[])EnumSet.complementOf(EnumSet.copyOf(enabledLabels)).stream().map(Label::toString).toArray(String[]::new);
        registry.config().meterFilter(MeterFilter.ignoreTags(ignored));
        matches.forEach(m3 -> {
            switch (m3.getType()) {
                case EQUALS: {
                    if (m3.getAlias() == null) {
                        registry.config().meterFilter(MeterFilter.deny(id -> {
                            if (m3.getDomain() != null && !id.getName().startsWith(m3.getDomain().getPrefix())) {
                                return false;
                            }
                            String tagValue = id.getTag(m3.getLabel());
                            return !m3.getValue().equals(tagValue);
                        }));
                        break;
                    }
                    registry.config().meterFilter(BackendRegistries.replaceTagValues(m3.getDomain(), m3.getLabel(), val -> {
                        if (m3.getValue().equals(val)) {
                            return m3.getAlias();
                        }
                        return val;
                    }));
                    break;
                }
                case REGEX: {
                    Pattern pattern = Pattern.compile(m3.getValue());
                    if (m3.getAlias() == null) {
                        registry.config().meterFilter(MeterFilter.accept(id -> {
                            if (m3.getDomain() != null && !id.getName().startsWith(m3.getDomain().getPrefix())) {
                                return true;
                            }
                            String tagValue = id.getTag(m3.getLabel());
                            if (tagValue == null) {
                                return false;
                            }
                            return pattern.matcher(tagValue).matches();
                        }));
                        break;
                    }
                    registry.config().meterFilter(BackendRegistries.replaceTagValues(m3.getDomain(), m3.getLabel(), val -> {
                        if (pattern.matcher((CharSequence)val).matches()) {
                            return m3.getAlias();
                        }
                        return val;
                    }));
                }
            }
        });
    }

    private static MeterFilter replaceTagValues(final MetricsDomain domain, final String tagKey, final Function<String, String> replacement) {
        return new MeterFilter(){

            @Override
            public Meter.Id map(Meter.Id id) {
                if (domain != null && !id.getName().startsWith(domain.getPrefix())) {
                    return id;
                }
                return MeterFilter.replaceTagValues(tagKey, replacement, new String[0]).map(id);
            }
        };
    }
}

