/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.jdbcbridge.internal.vertx.micrometer.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.Tag;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.net.SocketAddress;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.micrometer.Label;

public final class Labels {
    private Labels() {
    }

    static String address(SocketAddress address) {
        return Labels.address(address, null);
    }

    static String address(SocketAddress address, String nameOverride) {
        if (address == null) {
            return "?";
        }
        if (nameOverride == null) {
            return address.toString();
        }
        SocketAddress addrOverride = address.port() >= 0 ? SocketAddress.inetSocketAddress(address.port(), nameOverride) : SocketAddress.domainSocketAddress(nameOverride);
        return addrOverride.toString();
    }

    static String getSide(boolean local) {
        return local ? "local" : "remote";
    }

    public static List<Tag> toTags(Label[] keys, String[] values) {
        if (keys.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<Tag> tags = new ArrayList<Tag>(keys.length);
        for (int i = 0; i < keys.length; ++i) {
            if (values[i] == null) continue;
            String lowKey = keys[i].toString();
            tags.add(Tag.of(lowKey, values[i]));
        }
        return tags;
    }
}

