/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.jdbcbridge.internal.vertx.micrometer.impl;

import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.MeterRegistry;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.net.SocketAddress;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.spi.metrics.DatagramSocketMetrics;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.micrometer.Label;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.micrometer.MetricsDomain;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.micrometer.impl.AbstractMetrics;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.micrometer.impl.Labels;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.micrometer.impl.meters.Counters;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.micrometer.impl.meters.Summaries;

class VertxDatagramSocketMetrics
extends AbstractMetrics
implements DatagramSocketMetrics {
    private final Summaries bytesReceived = this.summaries("bytesReceived", "Total number of datagram bytes received", Label.LOCAL);
    private final Summaries bytesSent = this.summaries("bytesSent", "Total number of datagram bytes sent", new Label[0]);
    private final Counters errorCount = this.counters("errors", "Total number of datagram errors", Label.CLASS_NAME);
    private volatile String localAddress;

    VertxDatagramSocketMetrics(MeterRegistry registry) {
        super(registry, MetricsDomain.DATAGRAM_SOCKET);
    }

    @Override
    public void listening(String localName, SocketAddress localAddress) {
        this.localAddress = Labels.address(localAddress, localName);
    }

    @Override
    public void bytesRead(Void socketMetric, SocketAddress remoteAddress, long numberOfBytes) {
        if (this.localAddress != null) {
            this.bytesReceived.get(this.localAddress).record(numberOfBytes);
        }
    }

    @Override
    public void bytesWritten(Void socketMetric, SocketAddress remoteAddress, long numberOfBytes) {
        this.bytesSent.get(new String[0]).record(numberOfBytes);
    }

    @Override
    public void exceptionOccurred(Void socketMetric, SocketAddress remoteAddress, Throwable t) {
        this.errorCount.get(t.getClass().getSimpleName()).increment();
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public void close() {
    }
}

