/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.jdbcbridge.internal.vertx.micrometer.impl;

import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.binder.jvm.ClassLoaderMetrics;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.binder.jvm.JvmGcMetrics;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.binder.jvm.JvmMemoryMetrics;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.binder.jvm.JvmThreadMetrics;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.binder.system.ProcessorMetrics;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.VertxOptions;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.json.JsonObject;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.metrics.MetricsOptions;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.spi.VertxMetricsFactory;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.spi.metrics.VertxMetrics;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.micrometer.MicrometerMetricsOptions;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.micrometer.backends.BackendRegistries;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.micrometer.backends.BackendRegistry;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.micrometer.impl.VertxMetricsImpl;

public class VertxMetricsFactoryImpl
implements VertxMetricsFactory {
    @Override
    public VertxMetrics metrics(VertxOptions vertxOptions) {
        MetricsOptions metricsOptions = vertxOptions.getMetricsOptions();
        MicrometerMetricsOptions options = metricsOptions instanceof MicrometerMetricsOptions ? (MicrometerMetricsOptions)metricsOptions : new MicrometerMetricsOptions(metricsOptions.toJson());
        BackendRegistry backendRegistry = BackendRegistries.setupBackend(options);
        VertxMetricsImpl metrics = new VertxMetricsImpl(options, backendRegistry);
        metrics.init();
        if (options.isJvmMetricsEnabled()) {
            new ClassLoaderMetrics().bindTo(backendRegistry.getMeterRegistry());
            new JvmMemoryMetrics().bindTo(backendRegistry.getMeterRegistry());
            new JvmGcMetrics().bindTo(backendRegistry.getMeterRegistry());
            new ProcessorMetrics().bindTo(backendRegistry.getMeterRegistry());
            new JvmThreadMetrics().bindTo(backendRegistry.getMeterRegistry());
        }
        return metrics;
    }

    @Override
    public MetricsOptions newOptions() {
        return this.newOptions(null);
    }

    @Override
    public MetricsOptions newOptions(JsonObject jsonObject) {
        return jsonObject == null ? new MicrometerMetricsOptions() : new MicrometerMetricsOptions(jsonObject);
    }
}

