/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.jdbcbridge.internal.vertx.micrometer.impl;

import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.MeterRegistry;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.Verticle;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.datagram.DatagramSocketOptions;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.http.HttpClientOptions;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.http.HttpServerOptions;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.metrics.impl.DummyVertxMetrics;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.net.NetClientOptions;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.net.NetServerOptions;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.net.SocketAddress;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.spi.metrics.DatagramSocketMetrics;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.spi.metrics.EventBusMetrics;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.spi.metrics.HttpClientMetrics;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.spi.metrics.HttpServerMetrics;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.spi.metrics.PoolMetrics;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.spi.metrics.TCPMetrics;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.spi.metrics.VertxMetrics;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.micrometer.MetricsDomain;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.micrometer.MicrometerMetricsOptions;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.micrometer.backends.BackendRegistries;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.micrometer.backends.BackendRegistry;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.micrometer.impl.AbstractMetrics;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.micrometer.impl.VertxDatagramSocketMetrics;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.micrometer.impl.VertxEventBusMetrics;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.micrometer.impl.VertxHttpClientMetrics;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.micrometer.impl.VertxHttpServerMetrics;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.micrometer.impl.VertxNetClientMetrics;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.micrometer.impl.VertxNetServerMetrics;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.micrometer.impl.VertxPoolMetrics;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.micrometer.impl.VertxVerticleMetrics;

public class VertxMetricsImpl
extends AbstractMetrics
implements VertxMetrics {
    private final BackendRegistry backendRegistry;
    private final String registryName;
    private final EventBusMetrics eventBusMetrics;
    private final DatagramSocketMetrics datagramSocketMetrics;
    private final VertxNetClientMetrics netClientMetrics;
    private final VertxNetServerMetrics netServerMetrics;
    private final VertxHttpClientMetrics httpClientMetrics;
    private final VertxHttpServerMetrics httpServerMetrics;
    private final VertxPoolMetrics poolMetrics;
    private final VertxVerticleMetrics verticleMetrics;

    public VertxMetricsImpl(MicrometerMetricsOptions options, BackendRegistry backendRegistry) {
        super(backendRegistry.getMeterRegistry(), null);
        this.backendRegistry = backendRegistry;
        this.registryName = options.getRegistryName();
        MeterRegistry registry = backendRegistry.getMeterRegistry();
        this.eventBusMetrics = options.isMetricsCategoryDisabled(MetricsDomain.EVENT_BUS) ? null : new VertxEventBusMetrics(registry);
        this.datagramSocketMetrics = options.isMetricsCategoryDisabled(MetricsDomain.DATAGRAM_SOCKET) ? null : new VertxDatagramSocketMetrics(registry);
        this.netClientMetrics = options.isMetricsCategoryDisabled(MetricsDomain.NET_CLIENT) ? null : new VertxNetClientMetrics(registry);
        this.netServerMetrics = options.isMetricsCategoryDisabled(MetricsDomain.NET_SERVER) ? null : new VertxNetServerMetrics(registry);
        this.httpClientMetrics = options.isMetricsCategoryDisabled(MetricsDomain.HTTP_CLIENT) ? null : new VertxHttpClientMetrics(registry);
        this.httpServerMetrics = options.isMetricsCategoryDisabled(MetricsDomain.HTTP_SERVER) ? null : new VertxHttpServerMetrics(registry);
        this.poolMetrics = options.isMetricsCategoryDisabled(MetricsDomain.NAMED_POOLS) ? null : new VertxPoolMetrics(registry);
        this.verticleMetrics = options.isMetricsCategoryDisabled(MetricsDomain.VERTICLES) ? null : new VertxVerticleMetrics(registry);
    }

    void init() {
        this.backendRegistry.init();
    }

    @Override
    public void verticleDeployed(Verticle verticle) {
        if (this.verticleMetrics != null) {
            this.verticleMetrics.verticleDeployed(verticle);
        }
    }

    @Override
    public void verticleUndeployed(Verticle verticle) {
        if (this.verticleMetrics != null) {
            this.verticleMetrics.verticleUndeployed(verticle);
        }
    }

    @Override
    public void timerCreated(long l) {
    }

    @Override
    public void timerEnded(long l, boolean b) {
    }

    @Override
    public EventBusMetrics createEventBusMetrics() {
        if (this.eventBusMetrics != null) {
            return this.eventBusMetrics;
        }
        return DummyVertxMetrics.DummyEventBusMetrics.INSTANCE;
    }

    @Override
    public HttpServerMetrics<?, ?, ?> createHttpServerMetrics(HttpServerOptions httpClientOptions, SocketAddress socketAddress) {
        if (this.httpServerMetrics != null) {
            return this.httpServerMetrics.forAddress(socketAddress);
        }
        return DummyVertxMetrics.DummyHttpServerMetrics.INSTANCE;
    }

    @Override
    public HttpClientMetrics<?, ?, ?, ?, ?> createHttpClientMetrics(HttpClientOptions httpClientOptions) {
        if (this.httpClientMetrics != null) {
            return this.httpClientMetrics.forAddress(httpClientOptions.getLocalAddress());
        }
        return DummyVertxMetrics.DummyHttpClientMetrics.INSTANCE;
    }

    @Override
    public TCPMetrics<?> createNetServerMetrics(NetServerOptions netServerOptions, SocketAddress socketAddress) {
        if (this.netServerMetrics != null) {
            return this.netServerMetrics.forAddress(socketAddress);
        }
        return DummyVertxMetrics.DummyTCPMetrics.INSTANCE;
    }

    @Override
    public TCPMetrics<?> createNetClientMetrics(NetClientOptions netClientOptions) {
        if (this.netClientMetrics != null) {
            return this.netClientMetrics.forAddress(netClientOptions.getLocalAddress());
        }
        return DummyVertxMetrics.DummyTCPMetrics.INSTANCE;
    }

    @Override
    public DatagramSocketMetrics createDatagramSocketMetrics(DatagramSocketOptions options) {
        if (this.datagramSocketMetrics != null) {
            return this.datagramSocketMetrics;
        }
        return DummyVertxMetrics.DummyDatagramMetrics.INSTANCE;
    }

    @Override
    public PoolMetrics<?> createPoolMetrics(String poolType, String poolName, int maxPoolSize) {
        if (this.poolMetrics != null) {
            return this.poolMetrics.forInstance(poolType, poolName, maxPoolSize);
        }
        return DummyVertxMetrics.DummyWorkerPoolMetrics.INSTANCE;
    }

    @Override
    public boolean isMetricsEnabled() {
        return true;
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public void close() {
        BackendRegistries.stop(this.registryName);
    }
}

