/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.jdbcbridge.internal.vertx.micrometer.impl;

import java.util.concurrent.atomic.LongAdder;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.MeterRegistry;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.net.SocketAddress;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.core.spi.metrics.TCPMetrics;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.micrometer.Label;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.micrometer.MetricsDomain;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.micrometer.impl.AbstractMetrics;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.micrometer.impl.Labels;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.micrometer.impl.MicrometerMetrics;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.micrometer.impl.meters.Counters;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.micrometer.impl.meters.Gauges;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.micrometer.impl.meters.Summaries;

class VertxNetClientMetrics
extends AbstractMetrics {
    private final Gauges<LongAdder> connections = this.longGauges("connections", "Number of connections to the remote host currently opened", Label.LOCAL, Label.REMOTE);
    private final Summaries bytesReceived = this.summaries("bytesReceived", "Number of bytes received from the remote host", Label.LOCAL, Label.REMOTE);
    private final Summaries bytesSent = this.summaries("bytesSent", "Number of bytes sent to the remote host", Label.LOCAL, Label.REMOTE);
    private final Counters errorCount = this.counters("errors", "Number of errors", Label.LOCAL, Label.REMOTE, Label.CLASS_NAME);

    VertxNetClientMetrics(MeterRegistry registry) {
        this(registry, MetricsDomain.NET_CLIENT);
    }

    VertxNetClientMetrics(MeterRegistry registry, MetricsDomain domain) {
        super(registry, domain);
    }

    TCPMetrics forAddress(String localAddress) {
        return new Instance(localAddress);
    }

    class Instance
    implements MicrometerMetrics,
    TCPMetrics<String> {
        protected final String local;

        Instance(String localAddress) {
            this.local = localAddress == null ? "?" : localAddress;
        }

        @Override
        public String connected(SocketAddress remoteAddress, String remoteName) {
            String remote = Labels.address(remoteAddress, remoteName);
            ((LongAdder)VertxNetClientMetrics.this.connections.get(this.local, remote)).increment();
            return remote;
        }

        @Override
        public void disconnected(String remote, SocketAddress remoteAddress) {
            ((LongAdder)VertxNetClientMetrics.this.connections.get(this.local, remote)).decrement();
        }

        @Override
        public void bytesRead(String remote, SocketAddress remoteAddress, long numberOfBytes) {
            VertxNetClientMetrics.this.bytesReceived.get(this.local, remote).record(numberOfBytes);
        }

        @Override
        public void bytesWritten(String remote, SocketAddress remoteAddress, long numberOfBytes) {
            VertxNetClientMetrics.this.bytesSent.get(this.local, remote).record(numberOfBytes);
        }

        @Override
        public void exceptionOccurred(String remote, SocketAddress remoteAddress, Throwable t) {
            VertxNetClientMetrics.this.errorCount.get(this.local, remote, t.getClass().getSimpleName()).increment();
        }

        @Override
        public boolean isEnabled() {
            return true;
        }

        @Override
        public void close() {
        }

        @Override
        public MeterRegistry registry() {
            return VertxNetClientMetrics.this.registry;
        }

        @Override
        public String baseName() {
            return VertxNetClientMetrics.this.domain.getPrefix();
        }
    }
}

