/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.jdbcbridge.internal.vertx.micrometer.impl.meters;

import java.util.concurrent.TimeUnit;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.MeterRegistry;
import ru.yandex.clickhouse.jdbcbridge.internal.micrometer.core.instrument.Timer;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.micrometer.Label;
import ru.yandex.clickhouse.jdbcbridge.internal.vertx.micrometer.impl.Labels;

public class Timers {
    private final String name;
    private final String description;
    private final Label[] keys;
    private final MeterRegistry registry;

    public Timers(String name, String description, MeterRegistry registry, Label ... keys) {
        this.name = name;
        this.description = description;
        this.registry = registry;
        this.keys = keys;
    }

    public Timer get(String ... values) {
        return Timer.builder(this.name).description(this.description).tags(Labels.toTags(this.keys, values)).register(this.registry);
    }

    public EventTiming start() {
        return new EventTiming(this);
    }

    public static class EventTiming {
        private final Timers ref;
        private final long nanoStart;

        private EventTiming(Timers ref) {
            this.ref = ref;
            this.nanoStart = System.nanoTime();
        }

        public void end(String ... values) {
            Timer t = this.ref.get(values);
            t.record(System.nanoTime() - this.nanoStart, TimeUnit.NANOSECONDS);
        }
    }
}

