/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.jdbcbridge.internal.zaxxer.hikari.metrics.prometheus;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import ru.yandex.clickhouse.jdbcbridge.internal.prometheus.client.Collector;
import ru.yandex.clickhouse.jdbcbridge.internal.prometheus.client.CollectorRegistry;
import ru.yandex.clickhouse.jdbcbridge.internal.zaxxer.hikari.metrics.IMetricsTracker;
import ru.yandex.clickhouse.jdbcbridge.internal.zaxxer.hikari.metrics.MetricsTrackerFactory;
import ru.yandex.clickhouse.jdbcbridge.internal.zaxxer.hikari.metrics.PoolStats;
import ru.yandex.clickhouse.jdbcbridge.internal.zaxxer.hikari.metrics.prometheus.HikariCPCollector;
import ru.yandex.clickhouse.jdbcbridge.internal.zaxxer.hikari.metrics.prometheus.PrometheusMetricsTracker;

public class PrometheusMetricsTrackerFactory
implements MetricsTrackerFactory {
    private static final Map<CollectorRegistry, RegistrationStatus> registrationStatuses = new ConcurrentHashMap<CollectorRegistry, RegistrationStatus>();
    private final HikariCPCollector collector = new HikariCPCollector();
    private final CollectorRegistry collectorRegistry;

    public PrometheusMetricsTrackerFactory() {
        this(CollectorRegistry.defaultRegistry);
    }

    public PrometheusMetricsTrackerFactory(CollectorRegistry collectorRegistry) {
        this.collectorRegistry = collectorRegistry;
    }

    @Override
    public IMetricsTracker create(String poolName, PoolStats poolStats) {
        this.registerCollector(this.collector, this.collectorRegistry);
        this.collector.add(poolName, poolStats);
        return new PrometheusMetricsTracker(poolName, this.collectorRegistry, this.collector);
    }

    private void registerCollector(Collector collector, CollectorRegistry collectorRegistry) {
        if (registrationStatuses.putIfAbsent(collectorRegistry, RegistrationStatus.REGISTERED) == null) {
            collector.register(collectorRegistry);
        }
    }

    public static enum RegistrationStatus {
        REGISTERED;

    }
}

