/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.jdbcbridge.core;

import com.fasterxml.jackson.core.io.JsonStringEncoder;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.prometheus.PrometheusConfig;
import io.micrometer.prometheus.PrometheusMeterRegistry;
import io.vertx.core.json.JsonObject;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Stack;
import java.util.concurrent.TimeUnit;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import javax.script.Bindings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.yandex.clickhouse.jdbcbridge.core.ExpandedUrlClassLoader;
import ru.yandex.clickhouse.jdbcbridge.core.Extension;
import ru.yandex.clickhouse.jdbcbridge.core.TypedParameter;

public final class Utils {
    private static final Logger log = LoggerFactory.getLogger(Utils.class);
    private static final ClassLoader extClassLoader = new ExpandedUrlClassLoader(Utils.class.getClassLoader(), Utils.getConfiguration("extensions", "EXTENSION_DIR", "jdbc-bridge.extension.dir"));
    private static final MeterRegistry defaultRegistry = new PrometheusMeterRegistry(PrometheusConfig.DEFAULT);
    private static final String MSG_DIGEST_ALGORTITHM = "SHA-512";
    private static final char[][] CLAUSE_CHARS = new char[][]{{'`', '`'}, {'\'', '\''}, {'(', ')'}};
    public static final String VARIABLE_PREFIX = "{{";
    public static final String VARIABLE_SUFFIX = "}}";
    public static final String EMPTY_STRING = "";
    public static final String NULL_STRING = "null";
    public static final int OBJECT_DEPTH_LIMIT = 10;
    public static final int U_INT8_MAX = 255;
    public static final int U_INT16_MAX = 65535;
    public static final long U_INT32_MAX = 0xFFFFFFFFL;
    public static final long MILLIS_IN_DAY = TimeUnit.DAYS.toMillis(1L);
    public static final long DATETIME_MAX = 4294967295000L;
    public static final String DEFAULT_COLUMN_NAME = "results";

    private static boolean isRow(Object object) {
        boolean result = false;
        if (object != null) {
            Class<?> clazz = object.getClass();
            result = char[].class.equals(clazz) || boolean[].class.equals(clazz) || byte[].class.equals(clazz) || short[].class.equals(clazz) || int[].class.equals(clazz) || long[].class.equals(clazz) || float[].class.equals(clazz) || double[].class.equals(clazz) || byte[].class.equals(clazz) || object instanceof Enumeration || object instanceof Iterable || clazz.isArray() || object instanceof Map;
        }
        return result;
    }

    private static void addObjects(Object object, List<Object> list, boolean asColumn, String ... columnNames) {
        if (object == null) {
            list.add(null);
            return;
        }
        Class<?> clazz = object.getClass();
        if (char[].class.equals(clazz)) {
            if (asColumn) {
                for (char v : (char[])object) {
                    list.add(Character.valueOf(v));
                }
            } else {
                char[] values = (char[])object;
                int len = values.length;
                if (len > 0) {
                    Object[] columns = new Object[len];
                    for (int i = 0; i < len; ++i) {
                        columns[i] = Character.valueOf(values[i]);
                    }
                    list.add(columns);
                }
            }
        } else if (boolean[].class.equals(clazz)) {
            if (asColumn) {
                for (boolean v : (boolean[])object) {
                    list.add(v);
                }
            } else {
                boolean[] values = (boolean[])object;
                int len = values.length;
                if (len > 0) {
                    Object[] columns = new Object[len];
                    for (int i = 0; i < len; ++i) {
                        columns[i] = values[i];
                    }
                    list.add(columns);
                }
            }
        } else if (byte[].class.equals(clazz)) {
            if (asColumn) {
                for (byte v : (byte[])object) {
                    list.add(v);
                }
            } else {
                byte[] values = (byte[])object;
                int len = values.length;
                if (len > 0) {
                    Object[] columns = new Object[len];
                    for (int i = 0; i < len; ++i) {
                        columns[i] = values[i];
                    }
                    list.add(columns);
                }
            }
        } else if (short[].class.equals(clazz)) {
            if (asColumn) {
                for (short v : (short[])object) {
                    list.add(v);
                }
            } else {
                short[] values = (short[])object;
                int len = values.length;
                if (len > 0) {
                    Object[] columns = new Object[len];
                    for (int i = 0; i < len; ++i) {
                        columns[i] = values[i];
                    }
                    list.add(columns);
                }
            }
        } else if (int[].class.equals(clazz)) {
            if (asColumn) {
                for (int v : (int[])object) {
                    list.add(v);
                }
            } else {
                int[] values = (int[])object;
                int len = values.length;
                if (len > 0) {
                    Object[] columns = new Object[len];
                    for (int i = 0; i < len; ++i) {
                        columns[i] = values[i];
                    }
                    list.add(columns);
                }
            }
        } else if (long[].class.equals(clazz)) {
            if (asColumn) {
                for (long v : (long[])object) {
                    list.add(v);
                }
            } else {
                long[] values = (long[])object;
                int len = values.length;
                if (len > 0) {
                    Object[] columns = new Object[len];
                    for (int i = 0; i < len; ++i) {
                        columns[i] = values[i];
                    }
                    list.add(columns);
                }
            }
        } else if (float[].class.equals(clazz)) {
            if (asColumn) {
                for (float v : (float[])object) {
                    list.add(Float.valueOf(v));
                }
            } else {
                float[] values = (float[])object;
                int len = values.length;
                if (len > 0) {
                    Object[] columns = new Object[len];
                    for (int i = 0; i < len; ++i) {
                        columns[i] = Float.valueOf(values[i]);
                    }
                    list.add(columns);
                }
            }
        } else if (double[].class.equals(clazz)) {
            if (asColumn) {
                for (double v : (double[])object) {
                    list.add(v);
                }
            } else {
                double[] values = (double[])object;
                int len = values.length;
                if (len > 0) {
                    Object[] columns = new Object[len];
                    for (int i = 0; i < len; ++i) {
                        columns[i] = values[i];
                    }
                    list.add(columns);
                }
            }
        } else if (object instanceof Enumeration) {
            Enumeration e = (Enumeration)object;
            if (asColumn) {
                while (e.hasMoreElements()) {
                    list.add(e.nextElement());
                }
            } else {
                ArrayList subList = new ArrayList(columnNames.length);
                boolean isFirst = true;
                boolean notRow = true;
                while (e.hasMoreElements()) {
                    Object value = e.nextElement();
                    if (isFirst) {
                        notRow = !Utils.isRow(value);
                        isFirst = false;
                    }
                    Utils.addObjects(value, notRow ? subList : list, notRow, columnNames);
                }
                int size = subList.size();
                if (size > 0) {
                    list.add(subList.toArray(new Object[size]));
                }
            }
        } else if (object instanceof Iterable) {
            if (asColumn) {
                for (Object o : (Iterable)object) {
                    list.add(o);
                }
            } else {
                int columnsCount = columnNames.length;
                ArrayList subList = new ArrayList(columnsCount);
                boolean isFirst = true;
                boolean notRow = true;
                for (Object o : (Iterable)object) {
                    if (isFirst) {
                        notRow = !Utils.isRow(o);
                        isFirst = false;
                    }
                    Utils.addObjects(o, notRow ? subList : list, notRow, columnNames);
                }
                int size = subList.size();
                if (size > 0) {
                    list.add(subList.toArray(new Object[size]));
                }
            }
        } else if (clazz.isArray()) {
            if (asColumn) {
                for (Object o : (Object[])object) {
                    list.add(o);
                }
            } else {
                int columnsCount = columnNames.length;
                ArrayList subList = new ArrayList(columnsCount);
                boolean isFirst = true;
                boolean notRow = true;
                for (Object o : object) {
                    if (isFirst) {
                        notRow = !Utils.isRow(o);
                        isFirst = false;
                    }
                    Utils.addObjects(o, notRow ? subList : list, notRow, columnNames);
                }
                int size = subList.size();
                if (size > 0) {
                    list.add(subList.toArray(new Object[size]));
                }
            }
        } else if (object instanceof Bindings && Utils.isArray((Bindings)object)) {
            Bindings bindings = (Bindings)object;
            if (asColumn) {
                for (Object value : bindings.values()) {
                    list.add(value);
                }
            } else {
                int columnsCount = columnNames.length;
                ArrayList subList = new ArrayList(columnsCount);
                boolean isFirst = true;
                boolean notRow = true;
                for (Object value : bindings.values()) {
                    if (isFirst) {
                        notRow = !Utils.isRow(value);
                        isFirst = false;
                    }
                    Utils.addObjects(value, notRow ? subList : list, notRow, columnNames);
                }
                int size = subList.size();
                if (size > 0) {
                    list.add(subList.toArray(new Object[size]));
                }
            }
        } else if (object instanceof Map) {
            if (asColumn) {
                list.add(object);
            } else if (columnNames.length == 1) {
                list.add(new Object[]{object});
            } else {
                Map m = (Map)object;
                ArrayList subList = new ArrayList(columnNames.length);
                for (String name : columnNames) {
                    subList.add(m.get(name));
                }
                int size = subList.size();
                if (size > 0) {
                    list.add(subList.toArray(new Object[size]));
                }
            }
        } else {
            Object[] objectArray;
            if (asColumn) {
                objectArray = object;
            } else {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = object;
            }
            list.add(objectArray);
        }
    }

    private static int checkDepth(Object obj, int depth) {
        if (++depth > 10) {
            throw new IllegalArgumentException("Too many levels to expand - please simplify the object hierarchy by limiting nested levels less than 10");
        }
        return depth;
    }

    private static void appendJsonString(Object object, StringBuilder json, int depth) {
        if (object == null) {
            json.append(NULL_STRING);
            return;
        }
        depth = Utils.checkDepth(object, depth);
        Class<?> clazz = object.getClass();
        if (clazz.isPrimitive() && !Character.TYPE.equals(clazz) || Boolean.class.equals(clazz) || object instanceof Number) {
            json.append(String.valueOf(object));
        } else if (char[].class.equals(clazz)) {
            char[] array = (char[])object;
            json.append('[');
            JsonStringEncoder encoder = JsonStringEncoder.getInstance();
            for (int i = 0; i < array.length; ++i) {
                if (i > 0) {
                    json.append(',');
                }
                json.append('\"');
                encoder.quoteAsString((CharSequence)String.valueOf(array[i]), json);
                json.append('\"');
            }
            json.append(']');
        } else if (Character[].class.equals(clazz)) {
            Character[] array = (Character[])object;
            json.append('[');
            JsonStringEncoder encoder = JsonStringEncoder.getInstance();
            for (int i = 0; i < array.length; ++i) {
                if (i > 0) {
                    json.append(',');
                }
                json.append('\"');
                Character value = array[i];
                if (value == null) {
                    json.append(NULL_STRING);
                } else {
                    encoder.quoteAsString((CharSequence)String.valueOf(value), json);
                }
                json.append('\"');
            }
            json.append(']');
        } else if (boolean[].class.equals(clazz)) {
            json.append(Arrays.toString((boolean[])object));
        } else if (Boolean[].class.equals(clazz)) {
            json.append(Arrays.toString((Object[])((Boolean[])object)));
        } else if (byte[].class.equals(clazz)) {
            json.append(Arrays.toString((byte[])object));
        } else if (Byte[].class.equals(clazz)) {
            json.append(Arrays.toString((Object[])((Byte[])object)));
        } else if (short[].class.equals(clazz)) {
            json.append(Arrays.toString((short[])object));
        } else if (Short[].class.equals(clazz)) {
            json.append(Arrays.toString((Object[])((Short[])object)));
        } else if (int[].class.equals(clazz)) {
            json.append(Arrays.toString((int[])object));
        } else if (Integer[].class.equals(clazz)) {
            json.append(Arrays.toString((Object[])((Integer[])object)));
        } else if (long[].class.equals(clazz)) {
            json.append(Arrays.toString((long[])object));
        } else if (Long[].class.equals(clazz)) {
            json.append(Arrays.toString((Object[])((Long[])object)));
        } else if (float[].class.equals(clazz)) {
            json.append(Arrays.toString((float[])object));
        } else if (Float[].class.equals(clazz)) {
            json.append(Arrays.toString((Object[])((Float[])object)));
        } else if (double[].class.equals(clazz)) {
            json.append(Arrays.toString((double[])object));
        } else if (Double[].class.equals(clazz)) {
            json.append(Arrays.toString((Object[])((Double[])object)));
        } else if (object instanceof Enumeration) {
            json.append('[');
            Enumeration e = (Enumeration)object;
            boolean isNotFirst = false;
            while (e.hasMoreElements()) {
                if (isNotFirst) {
                    json.append(',');
                } else {
                    isNotFirst = true;
                }
                Utils.appendJsonString(e.nextElement(), json, depth);
            }
            json.append(']');
        } else if (object instanceof Iterable) {
            json.append('[');
            boolean isNotFirst = false;
            for (Object o : (Iterable)object) {
                if (isNotFirst) {
                    json.append(',');
                } else {
                    isNotFirst = true;
                }
                Utils.appendJsonString(o, json, depth);
            }
            json.append(']');
        } else if (clazz.isArray()) {
            Object[] array = (Object[])object;
            json.append('[');
            for (int i = 0; i < array.length; ++i) {
                Object value;
                if (i > 0) {
                    json.append(',');
                }
                if ((value = array[i]) == null) {
                    json.append(NULL_STRING);
                    continue;
                }
                Utils.appendJsonString(value, json, depth);
            }
            json.append(']');
        } else if (object instanceof Map) {
            json.append('{');
            boolean isNotFirst = false;
            for (Map.Entry o : ((Map)object).entrySet()) {
                if (isNotFirst) {
                    json.append(',');
                } else {
                    isNotFirst = true;
                }
                json.append('\"');
                JsonStringEncoder.getInstance().quoteAsString((CharSequence)String.valueOf(o.getKey()), json);
                json.append('\"').append(':');
                Utils.appendJsonString(o.getValue(), json, depth);
            }
            json.append('}');
        } else {
            json.append('\"');
            JsonStringEncoder.getInstance().quoteAsString((CharSequence)String.valueOf(object), json);
            json.append('\"');
        }
    }

    private static void appendJsonString(Bindings bindings, StringBuilder json, int depth) {
        if (bindings == null) {
            json.append(NULL_STRING);
            return;
        }
        depth = Utils.checkDepth(bindings, depth);
        if (Utils.isArray(bindings)) {
            json.append('[');
            boolean isNotFirst = false;
            for (Object value : bindings.values()) {
                if (isNotFirst) {
                    json.append(',');
                } else {
                    isNotFirst = true;
                }
                if (value == null) {
                    json.append(NULL_STRING);
                    continue;
                }
                if (value instanceof Bindings) {
                    Utils.appendJsonString(bindings, json, depth);
                    continue;
                }
                Utils.appendJsonString(value, json, depth);
            }
            json.append(']');
        } else {
            json.append('{');
            boolean isNotFirst = false;
            for (String key : bindings.keySet()) {
                if (isNotFirst) {
                    json.append(',');
                } else {
                    isNotFirst = true;
                }
                json.append('\"');
                JsonStringEncoder.getInstance().quoteAsString((CharSequence)key, json);
                json.append('\"').append(':');
                Object value = bindings.get(key);
                if (value == null) {
                    json.append(NULL_STRING);
                    continue;
                }
                if (value instanceof Bindings) {
                    Utils.appendJsonString((Bindings)value, json, depth);
                    continue;
                }
                Utils.appendJsonString(value, json, depth);
            }
            json.append('}');
        }
    }

    public static String unescapeQuotes(String str) {
        if (str == null) {
            return EMPTY_STRING;
        }
        int len = str.length();
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            char ch = str.charAt(i);
            if (i + 1 < len) {
                char nextCh = str.charAt(i + 1);
                if ((ch == '\\' || ch == '\'') && nextCh == '\'') {
                    sb.append('\'');
                    ++i;
                    continue;
                }
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    public static boolean containsWhitespace(String str) {
        boolean result = false;
        if (str != null) {
            for (int i = 0; i < str.length(); ++i) {
                char ch = str.charAt(i);
                if (!Character.isWhitespace(ch)) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    public static int indexOfKeywordIgnoreCase(String statement, String keyword) {
        return Utils.indexOfKeyword(statement, keyword, true);
    }

    public static int indexOfKeyword(String statement, String keyword, boolean caseInsensitive) {
        if (statement == null || keyword == null) {
            return -1;
        }
        int index = -1;
        char[][] chars = CLAUSE_CHARS;
        Stack<Character> stack = new Stack<Character>();
        char lastChar = '\u0000';
        int i = 0;
        int len = statement.length();
        int wnd = keyword.length();
        while (i + wnd <= len) {
            char actual = statement.charAt(i);
            for (int k = 0; k < chars.length; ++k) {
                char[] chs = chars[k];
                if (actual == lastChar && stack.size() > 0) {
                    stack.pop();
                    lastChar = stack.size() > 0 ? ((Character)stack.lastElement()).charValue() : (char)'\u0000';
                    break;
                }
                if (actual != chs[0]) continue;
                lastChar = chs[1];
                stack.push(Character.valueOf(lastChar));
                break;
            }
            if (stack.size() <= 0) {
                boolean matched = true;
                for (int j = 0; j < wnd; ++j) {
                    char expected;
                    actual = statement.charAt(i + j);
                    if (actual == (expected = keyword.charAt(j)) || caseInsensitive && Character.toUpperCase(actual) == Character.toUpperCase(expected)) continue;
                    matched = false;
                    break;
                }
                if (matched) {
                    index = i;
                    break;
                }
            }
            ++i;
        }
        return index;
    }

    public static final Object getDefaultMetricRegistry() {
        return defaultRegistry;
    }

    public static final String getValueOrEmptyString(String value) {
        return value == null || value.isEmpty() ? EMPTY_STRING : value;
    }

    public static String getConfiguration(String defaultValue, String environmentVariable, String systemProperty) {
        String value;
        String string = value = systemProperty == null ? EMPTY_STRING : Utils.getValueOrEmptyString(System.getProperty(systemProperty));
        if (value.isEmpty() && environmentVariable != null) {
            value = Utils.getValueOrEmptyString(System.getenv(environmentVariable));
        }
        if (value.isEmpty() && defaultValue != null) {
            value = defaultValue;
        }
        return value;
    }

    public static Extension<?> loadExtension(String className) {
        return Utils.loadExtension(null, className);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Extension<?> loadExtension(Collection<String> libUrls, String className) {
        Extension extension = null;
        ExpandedUrlClassLoader loader = new ExpandedUrlClassLoader(extClassLoader, libUrls == null || libUrls.size() == 0 ? new String[]{} : libUrls.toArray(new String[libUrls.size()]));
        Thread current = Thread.currentThread();
        ClassLoader currentLoader = current.getContextClassLoader();
        current.setContextClassLoader(loader);
        try {
            extension = new Extension(loader.loadClass(className));
        }
        catch (ClassNotFoundException e) {
            log.warn("Not able to find extension class: " + className);
        }
        catch (Exception e) {
            log.warn("Failed to load extension: " + className, (Throwable)e);
        }
        finally {
            current.setContextClassLoader(currentLoader);
        }
        return extension;
    }

    public static <T> T loadService(Class<T> service) {
        return Utils.loadService(service, extClassLoader);
    }

    public static <T> T loadService(Class<T> service, ClassLoader loader) {
        if (loader == null) {
            loader = Thread.currentThread().getContextClassLoader();
        }
        return ServiceLoader.load(service, loader).iterator().next();
    }

    public static boolean isArray(Bindings objects) {
        boolean isArray = true;
        if (!objects.isEmpty()) {
            int index = 0;
            for (String key : objects.keySet()) {
                if (String.valueOf(index++).equals(key)) continue;
                isArray = false;
                break;
            }
        }
        return isArray;
    }

    public static String toJsonString(Object object) {
        if (object == null) {
            return EMPTY_STRING;
        }
        StringBuilder json = new StringBuilder();
        int depth = 0;
        if (object instanceof Bindings) {
            Utils.appendJsonString((Bindings)object, json, depth);
        } else {
            Utils.appendJsonString(object, json, depth);
        }
        return json.toString();
    }

    public static Object[][] toObjectArrays(Object object, String ... columnNames) {
        Object[][] values;
        if (object == null) {
            return new Object[0][0];
        }
        if (columnNames == null || columnNames.length == 0) {
            columnNames = new String[]{DEFAULT_COLUMN_NAME};
        }
        ArrayList<Object> list = new ArrayList<Object>();
        Utils.addObjects(object, list, false, columnNames);
        int rowsCount = list.size();
        if (columnNames.length == 1 && rowsCount == 1) {
            Object v = list.get(0);
            if (v instanceof Object[]) {
                Object[] objs = (Object[])v;
                int len = objs.length;
                values = new Object[len][1];
                for (int i = 0; i < len; ++i) {
                    values[i][0] = objs[i];
                }
            } else {
                values = new Object[1][1];
                values[0][0] = v;
            }
        } else {
            int columnsCount = columnNames.length;
            values = new Object[rowsCount][columnsCount];
            for (int i = 0; i < rowsCount; ++i) {
                Object[] source = (Object[])list.get(i);
                Object[] target = values[i];
                if (source == null) continue;
                System.arraycopy(source, 0, target, 0, Math.min(source.length, target.length));
            }
        }
        return values;
    }

    public static void checkArgument(byte[] value, int length) {
        if (value.length > length) {
            throw new IllegalArgumentException("Given byte array should NOT greater than " + length);
        }
    }

    public static void checkArgument(int value, int minValue) {
        if (value < minValue) {
            throw new IllegalArgumentException("Given value(" + value + ") should NOT less than " + minValue);
        }
    }

    public static void checkArgument(long value, long minValue) {
        if (value < minValue) {
            throw new IllegalArgumentException("Given value(" + value + ") should NOT less than " + minValue);
        }
    }

    public static void checkArgument(int value, int minValue, int maxValue) {
        if (value < minValue || value > maxValue) {
            throw new IllegalArgumentException("Given value(" + value + ") should between " + minValue + " and " + maxValue);
        }
    }

    public static void checkArgument(long value, long minValue, long maxValue) {
        if (value < minValue || value > maxValue) {
            throw new IllegalArgumentException("Given value(" + value + ") should between " + minValue + " and " + maxValue);
        }
    }

    public static void checkArgument(BigInteger value, BigInteger minValue) {
        if (value.compareTo(minValue) < 0) {
            throw new IllegalArgumentException("Given value(" + value + ") should greater than " + minValue);
        }
    }

    public static void checkArgument(BigInteger value, BigInteger minValue, BigInteger maxValue) {
        if (value.compareTo(minValue) < 0 || value.compareTo(maxValue) > 0) {
            throw new IllegalArgumentException("Given value(" + value + ") should between " + minValue + " and " + maxValue);
        }
    }

    public static List<String> splitByChar(String str, char delimiter) {
        return Utils.splitByChar(str, delimiter, true);
    }

    public static List<String> splitByChar(String str, char delimiter, boolean tokenize) {
        LinkedList<String> list = new LinkedList<String>();
        if (str != null) {
            int startIndex = 0;
            int length = str.length();
            for (int i = 0; i <= length; ++i) {
                if (i != length && str.charAt(i) != delimiter) continue;
                if (tokenize && i >= startIndex) {
                    String matched = str.substring(startIndex, i).trim();
                    if (!matched.isEmpty()) {
                        list.add(matched);
                    }
                } else {
                    list.add(str.substring(startIndex, i));
                }
                startIndex = Math.min(i + 1, length);
            }
        }
        return list;
    }

    public static String digest(JsonObject o) {
        return Utils.digest(o == null ? (String)null : o.encode());
    }

    public static String digest(String s) {
        if (s == null || s.isEmpty()) {
            return EMPTY_STRING;
        }
        try {
            MessageDigest md = MessageDigest.getInstance(MSG_DIGEST_ALGORTITHM);
            return new BigInteger(1, md.digest(s.getBytes())).toString(16);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static void addTypedParameter(Map<String, TypedParameter<?>> map, TypedParameter<?> p) {
        if (map != null && p != null) {
            map.put(p.getName(), p);
        }
    }

    public static boolean fileExists(String file) {
        boolean exists = false;
        try {
            exists = Files.exists(Paths.get(file, new String[0]), new LinkOption[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return exists;
    }

    public static String loadTextFromFile(String file) {
        log.info("Loading text from file [{}]...", (Object)file);
        StringBuilder contentBuilder = new StringBuilder();
        try (Stream<String> stream = Files.lines(Paths.get(file, new String[0]), StandardCharsets.UTF_8);){
            stream.forEach(s -> contentBuilder.append((String)s).append('\n'));
        }
        catch (Exception e) {
            log.warn("Failed to load text from file", (Throwable)e);
        }
        return contentBuilder.toString();
    }

    public static JsonObject loadJsonFromFile(String file) {
        log.info("Loading JSON from file [{}]...", (Object)file);
        JsonObject config = null;
        StringBuilder contentBuilder = new StringBuilder();
        try (Stream<String> stream = Files.lines(Paths.get(file, new String[0]), StandardCharsets.UTF_8);){
            stream.forEach(s -> contentBuilder.append((String)s).append('\n'));
            config = new JsonObject(contentBuilder.toString());
        }
        catch (Exception e) {
            log.warn("Failed to load JSON from file " + file);
        }
        return config == null ? new JsonObject() : config;
    }

    public static String applyVariables(String template, UnaryOperator<String> operator) {
        if (template == null) {
            template = EMPTY_STRING;
        }
        if (operator == null) {
            return template;
        }
        StringBuilder sb = new StringBuilder();
        int len = template.length();
        for (int i = 0; i < len; ++i) {
            int index = template.indexOf(VARIABLE_PREFIX, i);
            if (index != -1) {
                sb.append(template.substring(i, index));
                i = index;
                index = template.indexOf(VARIABLE_SUFFIX, i);
                if (index != -1) {
                    String variable = template.substring(i + VARIABLE_PREFIX.length(), index).trim();
                    String value = (String)operator.apply(variable);
                    if (value == null) {
                        i += VARIABLE_PREFIX.length() - 1;
                        sb.append(VARIABLE_PREFIX);
                        continue;
                    }
                    i = index + VARIABLE_SUFFIX.length() - 1;
                    sb.append(value);
                    continue;
                }
                sb.append(template.substring(i));
                break;
            }
            sb.append(template.substring(i));
            break;
        }
        return sb.toString();
    }

    public static String applyVariables(String template, Map<String, String> variables) {
        return Utils.applyVariables(template, variables == null || variables.size() == 0 ? null : variables::get);
    }

    private Utils() {
    }
}

