/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.jdbcbridge.core;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EmptyStackException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Stack;
import javax.script.Bindings;
import ru.yandex.clickhouse.jdbcbridge.core.ColumnDefinition;
import ru.yandex.clickhouse.jdbcbridge.core.DataType;
import ru.yandex.clickhouse.jdbcbridge.core.Utils;

public class TableDefinition {
    public static final int DEFAULT_VERSION = 1;
    public static final String COLUMN_DATASOURCE = "datasource";
    public static final TableDefinition DEFAULT_RESULT_COLUMNS = new TableDefinition(new ColumnDefinition("results", DataType.Str, true, 0, 0, 0));
    public static final TableDefinition DEBUG_COLUMNS = new TableDefinition(new ColumnDefinition("datasource", DataType.Str, true, 0, 0, 0), new ColumnDefinition("type", DataType.Str, true, 0, 0, 0), new ColumnDefinition("definition", DataType.Str, true, 0, 0, 0), new ColumnDefinition("mtypes", DataType.Str, true, 0, 0, 0), new ColumnDefinition("query", DataType.Str, true, 0, 0, 0), new ColumnDefinition("parameters", DataType.Str, true, 0, 0, 0));
    public static final TableDefinition MUTATION_COLUMNS = new TableDefinition(new ColumnDefinition("type", DataType.Str, true, 0, 0, 0), new ColumnDefinition("rows", DataType.UInt64, false, 0, 0, 0));
    private static final String COLUMN_HEADER = "columns format version: ";
    private static final String COLUMN_COUNT = " columns:";
    private static final String CONF_VERSION = "version";
    private static final String CONF_QUERY = "query";
    private static final String CONF_COLUMNS = "columns";
    private final int version;
    private final ColumnDefinition[] columns;

    public TableDefinition(List<ColumnDefinition> columns) {
        this(1, columns.toArray(new ColumnDefinition[Objects.requireNonNull(columns).size()]));
    }

    public TableDefinition(ColumnDefinition ... columns) {
        this(1, columns);
    }

    public TableDefinition(int version, ColumnDefinition ... columns) {
        if (columns == null || columns.length == 0) {
            throw new IllegalArgumentException("At least one column is needed.");
        }
        this.version = version;
        this.columns = new ColumnDefinition[columns.length];
        for (int i = 0; i < columns.length; ++i) {
            ColumnDefinition column = columns[i];
            this.columns[i] = new ColumnDefinition(column);
        }
    }

    public TableDefinition(TableDefinition template, boolean insert, ColumnDefinition ... columns) {
        this.version = template.version;
        this.columns = new ColumnDefinition[template.columns.length + columns.length];
        if (insert) {
            System.arraycopy(columns, 0, this.columns, 0, columns.length);
            System.arraycopy(template.columns, 0, this.columns, columns.length, template.columns.length);
        } else {
            System.arraycopy(template.columns, 0, this.columns, 0, template.columns.length);
            System.arraycopy(columns, 0, this.columns, template.columns.length, columns.length);
        }
    }

    public static TableDefinition fromObject(Object types) {
        TableDefinition columns;
        if (types == null) {
            return DEFAULT_RESULT_COLUMNS;
        }
        Class<?> clazz = types.getClass();
        if (types instanceof TableDefinition) {
            columns = (TableDefinition)types;
        } else if (types instanceof ColumnDefinition[]) {
            columns = new TableDefinition((ColumnDefinition[])types);
        } else if (boolean[].class.equals(clazz)) {
            boolean[] array = (boolean[])types;
            ColumnDefinition[] dcs = new ColumnDefinition[array.length];
            int index = 0;
            for (boolean b : array) {
                dcs[index++] = ColumnDefinition.fromObject(b);
            }
            columns = new TableDefinition(dcs);
        } else if (byte[].class.equals(clazz)) {
            byte[] array = (byte[])types;
            ColumnDefinition[] dcs = new ColumnDefinition[array.length];
            int index = 0;
            for (byte b : array) {
                dcs[index++] = ColumnDefinition.fromObject(b);
            }
            columns = new TableDefinition(dcs);
        } else if (short[].class.equals(clazz)) {
            short[] array = (short[])types;
            ColumnDefinition[] dcs = new ColumnDefinition[array.length];
            int index = 0;
            for (short s : array) {
                dcs[index++] = ColumnDefinition.fromObject(s);
            }
            columns = new TableDefinition(dcs);
        } else if (int[].class.equals(clazz)) {
            int[] array = (int[])types;
            ColumnDefinition[] dcs = new ColumnDefinition[array.length];
            int index = 0;
            for (int i : array) {
                dcs[index++] = ColumnDefinition.fromObject(i);
            }
            columns = new TableDefinition(dcs);
        } else if (long[].class.equals(clazz)) {
            long[] array = (long[])types;
            ColumnDefinition[] dcs = new ColumnDefinition[array.length];
            int index = 0;
            for (long l : array) {
                dcs[index++] = ColumnDefinition.fromObject(l);
            }
            columns = new TableDefinition(dcs);
        } else if (float[].class.equals(clazz)) {
            float[] array = (float[])types;
            ColumnDefinition[] dcs = new ColumnDefinition[array.length];
            int index = 0;
            for (float f : array) {
                dcs[index++] = ColumnDefinition.fromObject(Float.valueOf(f));
            }
            columns = new TableDefinition(dcs);
        } else if (double[].class.equals(clazz)) {
            double[] array = (double[])types;
            ColumnDefinition[] dcs = new ColumnDefinition[array.length];
            int index = 0;
            for (double d : array) {
                dcs[index++] = ColumnDefinition.fromObject(d);
            }
            columns = new TableDefinition(dcs);
        } else if (types instanceof Enumeration) {
            Enumeration e = (Enumeration)types;
            ArrayList<ColumnDefinition> dcs = new ArrayList<ColumnDefinition>();
            while (e.hasMoreElements()) {
                dcs.add(ColumnDefinition.fromObject(e.nextElement()));
            }
            columns = new TableDefinition(dcs.toArray(new ColumnDefinition[dcs.size()]));
        } else if (types instanceof Iterable) {
            ArrayList<ColumnDefinition> dcs = new ArrayList<ColumnDefinition>();
            for (Object o : (Iterable)types) {
                dcs.add(ColumnDefinition.fromObject(o));
            }
            columns = new TableDefinition(dcs.toArray(new ColumnDefinition[dcs.size()]));
        } else if (clazz.isArray()) {
            Object[] array = (Object[])types;
            ColumnDefinition[] dcs = new ColumnDefinition[array.length];
            int index = 0;
            for (Object o : array) {
                dcs[index++] = ColumnDefinition.fromObject(o);
            }
            columns = new TableDefinition(dcs);
        } else if (types instanceof Bindings) {
            Bindings cols = (Bindings)types;
            if (Utils.isArray(cols)) {
                ColumnDefinition[] dcs = new ColumnDefinition[cols.size()];
                int index = 0;
                for (Object o : cols.values()) {
                    dcs[index++] = ColumnDefinition.fromObject(o);
                }
                columns = new TableDefinition(dcs);
            } else {
                columns = new TableDefinition(ColumnDefinition.fromObject(types));
            }
        } else {
            columns = types instanceof Map ? new TableDefinition(ColumnDefinition.fromObject(types)) : TableDefinition.fromJson(String.valueOf(types));
        }
        return columns;
    }

    public static TableDefinition fromJson(JsonArray config) {
        int version = 1;
        ColumnDefinition[] columns = new ColumnDefinition[]{};
        if (config == null) {
            columns = new ColumnDefinition[]{};
        } else {
            columns = new ColumnDefinition[config.size()];
            for (int i = 0; i < columns.length; ++i) {
                columns[i] = ColumnDefinition.fromJson(config.getJsonObject(i));
            }
        }
        return new TableDefinition(version, columns);
    }

    public static TableDefinition fromJson(String json) {
        int length = json == null ? 0 : json.length();
        JsonArray columns = null;
        for (int i = 0; i < length; ++i) {
            char c = json.charAt(i);
            if (c == '{') {
                JsonObject obj = new JsonObject(json);
                columns = obj.getJsonArray(CONF_COLUMNS);
                break;
            }
            if (c == '[') {
                columns = new JsonArray(json);
                break;
            }
            if (!Character.isWhitespace(c)) break;
        }
        return columns == null ? new TableDefinition(ColumnDefinition.fromObject(json)) : TableDefinition.fromJson(columns);
    }

    public static TableDefinition fromString(String columnsInfo) {
        int version = 1;
        ColumnDefinition[] columns = new ColumnDefinition[]{};
        if (columnsInfo != null) {
            if (columnsInfo.startsWith(COLUMN_HEADER)) {
                List<String> lines = Utils.splitByChar(columnsInfo, '\n');
                columns = new ColumnDefinition[lines.size() - 2];
                int index = 0;
                String currentLine = null;
                try {
                    Iterator<String> iterator = lines.iterator();
                    while (iterator.hasNext()) {
                        String c;
                        currentLine = c = iterator.next();
                        if (index == 0) {
                            version = Integer.parseInt(c.substring(COLUMN_HEADER.length()));
                        } else if (index == 1) {
                            if (!c.endsWith(COLUMN_COUNT)) {
                                throw new IllegalArgumentException("line #" + (index + 1) + " must be end with '" + COLUMN_COUNT + '\'');
                            }
                            String cCount = c.substring(0, c.length() - COLUMN_COUNT.length());
                            if (columns.length < Integer.parseInt(cCount)) {
                                throw new IllegalArgumentException("inconsistent columns count: declared " + cCount + " but looks like " + lines.size());
                            }
                        } else {
                            columns[index - 2] = ColumnDefinition.fromString(c);
                        }
                        ++index;
                    }
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("failed to parse line #" + (index + 1) + ":\n" + currentLine, e);
                }
            } else {
                Stack<Character> stack = new Stack<Character>();
                char lastChar = '\u0000';
                StringBuilder sb = new StringBuilder();
                ArrayList<String> splittedColumns = new ArrayList<String>();
                int len = columnsInfo.length();
                block14: for (int i = 0; i < len; ++i) {
                    char ch = columnsInfo.charAt(i);
                    switch (ch) {
                        case '\\': {
                            if (i + 1 >= len) continue block14;
                            sb.append(columnsInfo.charAt(++i));
                            continue block14;
                        }
                        case '\'': {
                            i = i + 1 < len && columnsInfo.charAt(i + 1) == '\'' ? i + 1 : i;
                            sb.append(ch);
                            if (lastChar != ch) {
                                lastChar = stack.push(Character.valueOf(ch)).charValue();
                                continue block14;
                            }
                            try {
                                stack.pop();
                                lastChar = stack.size() > 0 ? ((Character)stack.lastElement()).charValue() : (char)'\u0000';
                                continue block14;
                            }
                            catch (EmptyStackException e) {
                                throw new IllegalArgumentException("failed to parse given schema at position #" + (i + 1) + " around character [" + ch + ']', e);
                            }
                        }
                        case '(': {
                            char c = stack.push(Character.valueOf(ch)).charValue();
                            lastChar = c;
                            sb.append(c);
                            continue block14;
                        }
                        case ')': {
                            sb.append(ch);
                            if (lastChar != '(') continue block14;
                            try {
                                stack.pop();
                                continue block14;
                            }
                            catch (EmptyStackException e) {
                                throw new IllegalArgumentException("failed to parse given schema at position #" + (i + 1) + " around character [" + ch + ']', e);
                            }
                        }
                        case ',': {
                            if (stack.isEmpty()) {
                                splittedColumns.add(sb.toString());
                                sb.setLength(0);
                                continue block14;
                            }
                            sb.append(ch);
                            continue block14;
                        }
                        default: {
                            sb.append(ch);
                        }
                    }
                }
                if (sb.length() > 0) {
                    splittedColumns.add(sb.toString());
                }
                int index = 0;
                columns = new ColumnDefinition[splittedColumns.size()];
                for (String c : splittedColumns) {
                    columns[index++] = ColumnDefinition.fromString(c);
                }
            }
        }
        return new TableDefinition(version, columns);
    }

    public int getVersion() {
        return this.version;
    }

    public boolean hasColumn() {
        return this.columns.length > 0;
    }

    public boolean containsColumn(String columnName) {
        boolean found = false;
        for (ColumnDefinition col : this.columns) {
            if (!col.getName().equals(columnName)) continue;
            found = true;
            break;
        }
        return found;
    }

    public int size() {
        return this.columns.length;
    }

    public ColumnDefinition getColumn(int index) {
        return this.columns[index];
    }

    public ColumnDefinition[] getColumns() {
        return Arrays.copyOf(this.columns, this.columns.length);
    }

    public void updateValues(List<ColumnDefinition> refColumns) {
        if (refColumns == null || refColumns.size() == 0) {
            return;
        }
        block0: for (int i = 0; i < this.columns.length; ++i) {
            ColumnDefinition info = this.columns[i];
            for (int j = 0; j < refColumns.size(); ++j) {
                ColumnDefinition ref = refColumns.get(j);
                if (!info.getName().equals(ref.getName())) continue;
                info.value.merge(ref.value.getValue().toString());
                continue block0;
            }
        }
    }

    public String toJsonString(String query) {
        JsonObject config = new JsonObject();
        config.put(CONF_VERSION, Integer.valueOf(this.version));
        if (query != null) {
            config.put(CONF_QUERY, query);
        }
        if (this.columns != null && this.columns.length > 0) {
            JsonArray array = new JsonArray();
            for (ColumnDefinition info : this.columns) {
                array.add(info.toJson());
            }
            config.put(CONF_COLUMNS, array);
        }
        return config.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(COLUMN_HEADER).append(this.version).append('\n').append(this.columns.length).append(COLUMN_COUNT).append('\n');
        for (ColumnDefinition column : this.columns) {
            sb.append(column.toString()).append('\n');
        }
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.columns);
        result = 31 * result + this.version;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TableDefinition other = (TableDefinition)obj;
        return this.version == other.version && Arrays.equals(this.columns, other.columns);
    }
}

