/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.jdbcbridge.core;

import io.vertx.core.json.JsonObject;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.yandex.clickhouse.jdbcbridge.core.DnsResolver;
import ru.yandex.clickhouse.jdbcbridge.core.Extension;
import ru.yandex.clickhouse.jdbcbridge.core.ManagedEntity;
import ru.yandex.clickhouse.jdbcbridge.core.Repository;
import ru.yandex.clickhouse.jdbcbridge.core.UsageStats;
import ru.yandex.clickhouse.jdbcbridge.core.Utils;

public abstract class BaseRepository<T extends ManagedEntity>
implements Repository<T> {
    private static final Logger log = LoggerFactory.getLogger(BaseRepository.class);
    protected final Map<String, Extension<T>> types = Collections.synchronizedMap(new LinkedHashMap());
    protected final Map<String, T> mappings = Collections.synchronizedMap(new HashMap());
    private final Class<T> clazz;
    private final String name;
    private final DnsResolver resolver;
    private String defaultType = null;
    protected final Extension<T> defaultExtension;

    protected String getEntityName() {
        return this.name;
    }

    protected Extension<T> getExtensionByType(String type, boolean autoCreate) {
        Extension<T> extension;
        Extension<T> extension2 = extension = this.types.size() > 0 ? this.types.get(type) : null;
        if (extension == null) {
            if (autoCreate) {
                extension = this.defaultExtension;
            } else {
                throw new IllegalArgumentException("Unsupported type of " + this.getEntityName() + ": " + type);
            }
        }
        return extension;
    }

    protected T createFromType(String id, String type) {
        Extension<T> extension = this.getExtensionByType(type, false);
        return (T)(extension == null ? null : (ManagedEntity)extension.newInstance(id, this, null));
    }

    protected T createFromConfig(String id, JsonObject config) {
        String type;
        String string = type = config == null ? null : config.getString("type");
        if (type == null) {
            type = this.defaultType;
        }
        Extension<T> extension = this.getExtensionByType(type, true);
        return (T)((ManagedEntity)extension.newInstance(id, this, config));
    }

    protected void atomicAdd(T entity) {
    }

    protected void atomicRemove(T entity) {
    }

    protected void remove(String id) {
        List<Object> removedEntities;
        ManagedEntity entity;
        ManagedEntity managedEntity = entity = "".equals(id) ? null : (ManagedEntity)this.mappings.remove(id);
        if (entity == null) {
            return;
        }
        if (id != null && id.equals(entity.getId())) {
            log.info("Removing {}(id={}) and all its aliases...", (Object)this.getEntityName(), (Object)id);
            Set<String> aliases = entity.getAliases();
            removedEntities = new ArrayList(aliases.size());
            for (String alias : entity.getAliases()) {
                ManagedEntity ref = (ManagedEntity)this.mappings.get(alias);
                if (ref == null || alias.equals(ref.getId())) continue;
                log.info("Removing alias [{}] of {}(id={})...", new Object[]{alias, this.getEntityName(), ref.getId()});
                ManagedEntity removedEntity = (ManagedEntity)this.mappings.remove(alias);
                if (removedEntity == entity) continue;
                removedEntities.add(removedEntity);
            }
            if (entity instanceof Closeable) {
                if (log.isDebugEnabled()) {
                    log.debug("Closing {}(id={})...", (Object)this.getEntityName(), (Object)id);
                }
                try {
                    ((Closeable)((Object)entity)).close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.atomicRemove(entity);
        } else {
            log.info("Removing alias [{}] of {}(id={})...", new Object[]{id, this.getEntityName(), entity.getId()});
            removedEntities = Collections.singletonList(entity);
        }
        for (ManagedEntity managedEntity2 : removedEntities) {
            if (!(managedEntity2 instanceof Closeable)) continue;
            boolean matched = false;
            for (ManagedEntity v : this.mappings.values()) {
                if (managedEntity2 != v) continue;
                matched = true;
                break;
            }
            if (!matched) continue;
            if (log.isDebugEnabled()) {
                log.debug("Closing {}(id={})...", (Object)this.getEntityName(), (Object)managedEntity2.getId());
            }
            try {
                ((Closeable)((Object)managedEntity2)).close();
            }
            catch (Exception exception) {}
        }
    }

    protected void update(String id, JsonObject config) {
        boolean addEntity;
        ManagedEntity entity = (ManagedEntity)this.mappings.get(id);
        boolean bl = addEntity = entity == null;
        if (!addEntity && entity.isDifferentFrom(config)) {
            this.remove(id);
            addEntity = true;
        }
        if (addEntity && config != null) {
            log.info("Adding {}(id={})...", (Object)this.getEntityName(), (Object)id);
            try {
                entity = this.createFromConfig(id, config);
                this.mappings.put(id, entity);
                for (String alias : entity.getAliases()) {
                    if (this.mappings.containsKey(alias)) {
                        log.warn("Not able to add {} alias [{}] as it exists already", (Object)this.getEntityName(), (Object)alias);
                        continue;
                    }
                    this.mappings.put(alias, entity);
                }
                this.atomicAdd(entity);
            }
            catch (RuntimeException e) {
                log.warn("Failed to add " + this.getEntityName() + "(id=" + id + ")", (Throwable)e);
            }
        }
    }

    public BaseRepository(Class<T> clazz) {
        this.clazz = Objects.requireNonNull(clazz);
        this.name = clazz.getSimpleName();
        this.resolver = new DnsResolver();
        this.defaultExtension = new Extension<T>(clazz);
    }

    @Override
    public Class<T> getEntityClass() {
        return this.clazz;
    }

    @Override
    public boolean accept(Class<?> clazz) {
        return clazz != null && clazz.isAssignableFrom(this.clazz);
    }

    @Override
    public String resolve(String name) {
        return Utils.applyVariables(name, this.resolver::apply);
    }

    @Override
    public List<UsageStats> getUsageStats() {
        ArrayList<UsageStats> list = new ArrayList<UsageStats>(this.mappings.size());
        for (Map.Entry<String, T> entry : this.mappings.entrySet()) {
            UsageStats usage = ((ManagedEntity)entry.getValue()).getUsage(entry.getKey());
            if (usage == null) continue;
            list.add(usage);
        }
        return Collections.unmodifiableList(list);
    }

    @Override
    public void registerType(String type, Extension<T> extension) {
        String className = Objects.requireNonNull(extension).getProviderClass().getName();
        Extension<T> registered = this.types.put(type = type == null || type.isEmpty() ? extension.getName() : type, extension);
        if (registered != null) {
            log.warn("Discard [{}] as type [{}] is reserved by [{}]", new Object[]{className, type, registered.getClass().getName()});
            return;
        }
        log.info("Registering new type of {}: [{}] -> [{}]", new Object[]{this.getEntityName(), type, className});
        if (this.types.size() == 1) {
            this.defaultType = type;
            log.info("Default type of {} is set to [{}]", (Object)this.getEntityName(), (Object)this.defaultType);
        }
    }

    @Override
    public void put(String id, T entity) {
        Objects.requireNonNull(entity);
        if (id == null) {
            id = ((ManagedEntity)entity).getId();
        }
        this.remove(id);
        this.mappings.put(id, entity);
        this.atomicAdd(entity);
        for (String alias : ((ManagedEntity)entity).getAliases()) {
            if (alias == null || alias.isEmpty()) continue;
            ManagedEntity e = (ManagedEntity)this.mappings.get(alias);
            if (e != null && alias.equals(e.getId())) {
                log.warn("Not going to add alias [{}] as it's an ID reserved by another {}", (Object)alias, (Object)this.getEntityName());
                continue;
            }
            this.remove(alias);
            this.mappings.put(alias, entity);
        }
    }

    @Override
    public T get(String id) {
        String normalizedId;
        ManagedEntity entity = null;
        String string = normalizedId = id == null ? "" : id;
        if (this.types.size() > 0) {
            int index = normalizedId.indexOf(58);
            if (index >= 0) {
                return this.createFromType(normalizedId, normalizedId.substring(0, index));
            }
            index = normalizedId.indexOf(63);
            if (index >= 0) {
                normalizedId = normalizedId.substring(0, index);
            }
            if ((entity = (ManagedEntity)this.mappings.get(normalizedId)) == null) {
                throw new IllegalArgumentException(this.getEntityName() + " [" + normalizedId + "] does not exist!");
            }
        } else {
            entity = (ManagedEntity)this.mappings.get(id);
        }
        return (T)entity;
    }
}

