/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.jdbcbridge.core;

import io.vertx.core.buffer.Buffer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.Objects;
import java.util.TimeZone;
import java.util.UUID;
import ru.yandex.clickhouse.jdbcbridge.core.ColumnDefinition;
import ru.yandex.clickhouse.jdbcbridge.core.DataType;
import ru.yandex.clickhouse.jdbcbridge.core.DefaultValues;
import ru.yandex.clickhouse.jdbcbridge.core.Utils;

public final class ByteBuffer {
    protected int position = 0;
    protected final Buffer buffer;
    protected final TimeZone timezone;

    public static ByteBuffer wrap(Buffer buffer, TimeZone timezone) {
        return new ByteBuffer(buffer, timezone);
    }

    public static ByteBuffer wrap(Buffer buffer) {
        return ByteBuffer.wrap(buffer, TimeZone.getDefault());
    }

    public static ByteBuffer newInstance(int initialSizeHint, TimeZone timezone) {
        return new ByteBuffer(Buffer.buffer((int)initialSizeHint), timezone);
    }

    public static ByteBuffer newInstance(int initialSizeHint) {
        return ByteBuffer.newInstance(initialSizeHint, TimeZone.getDefault());
    }

    public static Buffer asBuffer(String str) {
        return ByteBuffer.newInstance((int)(str.length() * 2)).writeString((String)str).buffer;
    }

    private ByteBuffer(Buffer buffer, TimeZone timezone) {
        this.buffer = buffer != null ? buffer : Buffer.buffer();
        this.timezone = timezone == null ? TimeZone.getDefault() : timezone;
    }

    public int length() {
        return this.buffer.length();
    }

    public boolean isExausted() {
        return this.position >= this.buffer.length();
    }

    public int readUnsignedLeb128() {
        int read;
        int value = 0;
        int count = 0;
        do {
            read = this.buffer.getByte(this.position++) & 0xFF;
            value |= (read & 0x7F) << count * 7;
        } while ((read & 0x80) == 128 && ++count < 5);
        if ((read & 0x80) == 128) {
            throw new IllegalArgumentException("Invalid LEB128 sequence");
        }
        return value;
    }

    public ByteBuffer writeUnsignedLeb128(int value) {
        Utils.checkArgument(value, 0);
        for (int remaining = value >>> 7; remaining != 0; remaining >>>= 7) {
            this.buffer.appendByte((byte)(value & 0x7F | 0x80));
            value = remaining;
        }
        this.buffer.appendByte((byte)(value & 0x7F));
        return this;
    }

    public byte readByte() {
        return this.buffer.getByte(this.position++);
    }

    public ByteBuffer writeByte(byte value) {
        this.buffer.appendByte(value);
        return this;
    }

    public void readBytes(byte[] bytes) {
        this.readBytes(bytes, 0, bytes.length);
    }

    public void readBytes(byte[] bytes, int offset, int length) {
        byte[] readBytes = this.buffer.getBytes(this.position, this.position + length);
        this.position += length;
        System.arraycopy(readBytes, 0, bytes, 0, length);
    }

    public ByteBuffer writeBytes(byte[] value) {
        this.buffer.appendBytes(value);
        return this;
    }

    public boolean readBoolean() {
        byte value = this.readByte();
        Utils.checkArgument(value, 0, 1);
        return value == 1;
    }

    public ByteBuffer writeBoolean(boolean value) {
        return this.writeByte(value ? (byte)1 : 0);
    }

    public ByteBuffer writeBoolean(byte value) {
        return this.writeByte(value == 1 ? (byte)1 : 0);
    }

    public String readEnum() {
        return this.readString();
    }

    public String readEnum8() {
        return this.readString();
    }

    public String readEnum16() {
        return this.readString();
    }

    public ByteBuffer writeEnum(int value) {
        return this.writeEnum8(value);
    }

    public ByteBuffer writeEnum(String value) {
        return this.writeEnum8(value);
    }

    public ByteBuffer writeEnum8(byte value) {
        return this.writeInt8(value);
    }

    public ByteBuffer writeEnum8(int value) {
        return this.writeInt8(value);
    }

    public ByteBuffer writeEnum8(String value) {
        return this.writeString(value);
    }

    public ByteBuffer writeEnum16(int value) {
        return this.writeInt16(value);
    }

    public ByteBuffer writeEnum16(short value) {
        return this.writeInt16(value);
    }

    public ByteBuffer writeEnum16(String value) {
        return this.writeString(value);
    }

    public boolean readNull() {
        return this.readBoolean();
    }

    public ByteBuffer writeNull() {
        return this.writeBoolean(true);
    }

    public ByteBuffer writeNonNull() {
        return this.writeBoolean(false);
    }

    public byte readInt8() {
        return this.readByte();
    }

    public ByteBuffer writeInt8(byte value) {
        return this.writeByte(value);
    }

    public ByteBuffer writeInt8(int value) {
        Utils.checkArgument(value, -128);
        return value > 127 ? this.writeUInt8(value) : this.writeByte((byte)value);
    }

    public short readUInt8() {
        return (short)((long)this.readByte() & 0xFFL);
    }

    public ByteBuffer writeUInt8(int value) {
        Utils.checkArgument(value, 0, 255);
        return this.writeByte((byte)((long)value & 0xFFL));
    }

    public short readInt16() {
        short value = this.buffer.getShortLE(this.position);
        this.position += 2;
        return value;
    }

    public ByteBuffer writeInt16(short value) {
        this.buffer.appendByte((byte)(0xFFL & (long)value)).appendByte((byte)(0xFFL & (long)(value >> 8)));
        return this;
    }

    public ByteBuffer writeInt16(int value) {
        Utils.checkArgument(value, Short.MIN_VALUE);
        return value > 65535 ? this.writeUInt16(value) : this.writeInt16((short)value);
    }

    public int readUInt16() {
        return (int)((long)this.readInt16() & 0xFFFFL);
    }

    public ByteBuffer writeUInt16(int value) {
        Utils.checkArgument(value, 0, 65535);
        return this.writeInt16((short)((long)value & 0xFFFFL));
    }

    public int readInt32() {
        int value = this.buffer.getIntLE(this.position);
        this.position += 4;
        return value;
    }

    public ByteBuffer writeInt32(int value) {
        this.buffer.appendByte((byte)(0xFFL & (long)value)).appendByte((byte)(0xFFL & (long)(value >> 8))).appendByte((byte)(0xFFL & (long)(value >> 16))).appendByte((byte)(0xFFL & (long)(value >> 24)));
        return this;
    }

    public long readUInt32() {
        return (long)this.readInt32() & 0xFFFFFFFFL;
    }

    public ByteBuffer writeUInt32(long value) {
        Utils.checkArgument(value, 0L, 0xFFFFFFFFL);
        return this.writeInt32((int)(value & 0xFFFFFFFFL));
    }

    public long readInt64() {
        long value = this.buffer.getLongLE(this.position);
        this.position += 8;
        return value;
    }

    public ByteBuffer writeInt64(long value) {
        value = Long.reverseBytes(value);
        byte[] bytes = new byte[8];
        for (int i = 7; i >= 0; --i) {
            bytes[i] = (byte)(value & 0xFFL);
            value >>= 8;
        }
        return this.writeBytes(bytes);
    }

    public BigInteger readInt128() {
        byte[] r = new byte[16];
        for (int i = r.length - 1; i >= 0; --i) {
            r[i] = this.readByte();
        }
        return new BigInteger(r);
    }

    public ByteBuffer writeInt128(BigInteger value) {
        return this.writeBigInteger(value, DataType.Int128.getLength());
    }

    public BigInteger readInt256() {
        byte[] r = new byte[32];
        for (int i = r.length - 1; i >= 0; --i) {
            r[i] = this.readByte();
        }
        return new BigInteger(r);
    }

    public ByteBuffer writeInt256(BigInteger value) {
        return this.writeBigInteger(value, DataType.Int256.getLength());
    }

    public BigInteger readUInt64() {
        return new BigInteger(Long.toUnsignedString(this.readInt64()));
    }

    public ByteBuffer writeUInt64(long value) {
        Utils.checkArgument(value, 0L);
        return this.writeInt64(value);
    }

    public ByteBuffer writeUInt64(BigInteger value) {
        Utils.checkArgument(value, BigInteger.ZERO);
        return this.writeInt64(value.longValue());
    }

    public BigInteger readUInt128() {
        return this.readInt128();
    }

    public ByteBuffer writeUInt128(BigInteger value) {
        return this.writeInt128(value);
    }

    public BigInteger readUInt256() {
        return this.readInt256();
    }

    public ByteBuffer writeUInt256(BigInteger value) {
        return this.writeInt256(value);
    }

    public float readFloat32() {
        return Float.intBitsToFloat(this.readInt32());
    }

    public ByteBuffer writeFloat32(float value) {
        return this.writeInt32(Float.floatToIntBits(value));
    }

    public double readFloat64() {
        return Double.longBitsToDouble(this.readInt64());
    }

    public ByteBuffer writeFloat64(double value) {
        return this.writeInt64(Double.doubleToLongBits(value));
    }

    public ByteBuffer writeUUID(UUID value) {
        return this.writeInt64(value.getMostSignificantBits()).writeInt64(value.getLeastSignificantBits());
    }

    public UUID readUUID() {
        return new UUID(this.readInt64(), this.readInt64());
    }

    public ByteBuffer writeBigInteger(BigInteger value) {
        return this.writeBigInteger(value, 16);
    }

    public ByteBuffer writeBigInteger(BigInteger value, int length) {
        int i;
        byte empty = value.signum() == -1 ? (byte)-1 : 0;
        byte[] bytes = value.toByteArray();
        for (i = bytes.length - 1; i >= 0; --i) {
            this.writeByte(bytes[i]);
        }
        for (i = length - bytes.length; i > 0; --i) {
            this.writeByte(empty);
        }
        return this;
    }

    private BigInteger toBigInteger(BigDecimal value, int scale) {
        return value.multiply(BigDecimal.valueOf(10L).pow(scale)).toBigInteger();
    }

    public BigDecimal readDecimal(int precision, int scale) {
        return precision > 38 ? this.readDecimal256(scale) : (precision > 18 ? this.readDecimal128(scale) : (precision > 9 ? this.readDecimal64(scale) : this.readDecimal32(scale)));
    }

    public ByteBuffer writeDecimal(BigDecimal value, int precision, int scale) {
        return precision > 38 ? this.writeDecimal256(value, scale) : (precision > 18 ? this.writeDecimal128(value, scale) : (precision > 9 ? this.writeDecimal64(value, scale) : this.writeDecimal32(value, scale)));
    }

    public BigDecimal readDecimal32(int scale) {
        return new BigDecimal(this.readInt32()).divide(BigDecimal.valueOf(10L).pow(scale));
    }

    public ByteBuffer writeDecimal32(BigDecimal value, int scale) {
        return this.writeInt32(this.toBigInteger(value, scale).intValue());
    }

    public BigDecimal readDecimal64(int scale) {
        return new BigDecimal(this.readInt64()).divide(BigDecimal.valueOf(10L).pow(scale));
    }

    public ByteBuffer writeDecimal64(BigDecimal value, int scale) {
        return this.writeInt64(this.toBigInteger(value, scale).longValue());
    }

    public BigDecimal readDecimal128(int scale) {
        byte[] r = new byte[16];
        for (int i = r.length - 1; i >= 0; --i) {
            r[i] = this.readByte();
        }
        return new BigDecimal(new BigInteger(r), scale);
    }

    public ByteBuffer writeDecimal128(BigDecimal value, int scale) {
        return this.writeInt128(this.toBigInteger(value, scale));
    }

    public BigDecimal readDecimal256(int scale) {
        byte[] r = new byte[32];
        for (int i = r.length - 1; i >= 0; --i) {
            r[i] = this.readByte();
        }
        return new BigDecimal(new BigInteger(r), scale);
    }

    public ByteBuffer writeDecimal256(BigDecimal value, int scale) {
        return this.writeInt256(this.toBigInteger(value, scale));
    }

    public Timestamp readDateTime() {
        return this.readDateTime(null);
    }

    public Timestamp readDateTime(TimeZone tz) {
        long time = this.readUInt32() * 1000L;
        if ((tz = tz == null ? this.timezone : tz) != null) {
            time -= (long)tz.getOffset(time);
        }
        return new Timestamp(time <= 0L ? 1L : time);
    }

    public ByteBuffer writeDateTime(java.util.Date value) {
        return this.writeDateTime(value, null);
    }

    public ByteBuffer writeDateTime(java.util.Date value, TimeZone tz) {
        return this.writeDateTime(Objects.requireNonNull(value).getTime(), tz);
    }

    public ByteBuffer writeDateTime(Timestamp value, TimeZone tz) {
        return this.writeDateTime(Objects.requireNonNull(value).getTime(), tz);
    }

    public ByteBuffer writeDateTime(long time, TimeZone tz) {
        if ((tz = tz == null ? this.timezone : tz) != null) {
            time += (long)tz.getOffset(time);
        }
        if (time <= 0L) {
            time = 1L;
        } else if (time > 4294967295000L) {
            time = 4294967295000L;
        }
        if ((time /= 1000L) > Integer.MAX_VALUE) {
            this.buffer.appendBytes(new byte[]{(byte)(0xFFL & time), (byte)(0xFFL & time >> 8), (byte)(0xFFL & time >> 16), (byte)(0xFFL & time >> 24)});
        } else {
            this.writeUInt32((int)time);
        }
        return this;
    }

    public Timestamp readDateTime64() {
        return this.readDateTime64(null);
    }

    public Timestamp readDateTime64(TimeZone tz) {
        BigInteger time = this.readUInt64();
        if ((tz = tz == null ? this.timezone : tz) != null) {
            time = time.subtract(BigInteger.valueOf(tz.getOffset(time.longValue())));
        }
        if (time.compareTo(BigInteger.ZERO) < 0) {
            time = BigInteger.ONE;
        }
        return new Timestamp(time.longValue());
    }

    public ByteBuffer writeDateTime64(java.util.Date value, int scale) {
        return this.writeDateTime64(value, scale, null);
    }

    public ByteBuffer writeDateTime64(Timestamp value, int scale) {
        return this.writeDateTime64(value, scale, null);
    }

    public ByteBuffer writeDateTime64(java.util.Date value, int scale, TimeZone tz) {
        return this.writeDateTime64(Objects.requireNonNull(value).getTime(), 0, scale, tz);
    }

    public ByteBuffer writeDateTime64(Timestamp value, int scale, TimeZone tz) {
        return this.writeDateTime64(Objects.requireNonNull(value).getTime(), value.getNanos(), scale, tz);
    }

    public ByteBuffer writeDateTime64(long time, int nanos, int scale, TimeZone tz) {
        if ((tz = tz == null ? this.timezone : tz) != null) {
            time += (long)tz.getOffset(time);
        }
        if (time <= 0L) {
            long l = time = nanos > 0 ? (long)(nanos / 1000000) : 1L;
        }
        if (scale > 0) {
            double normalizedTime = time;
            if (nanos != 0) {
                normalizedTime = (double)(time - (long)(nanos / 1000000)) + (double)nanos / 1000000.0;
            }
            if (scale < 3) {
                time = BigDecimal.valueOf(normalizedTime).divide(BigDecimal.valueOf(10L).pow(3 - scale)).longValue();
            } else if (scale > 3) {
                time = BigDecimal.valueOf(normalizedTime).multiply(BigDecimal.valueOf(10L).pow(scale - 3)).longValue();
            }
        }
        return this.writeUInt64(time);
    }

    public Date readDate() {
        int daysSinceEpoch = this.readUInt16();
        return new Date((long)daysSinceEpoch * Utils.MILLIS_IN_DAY);
    }

    public ByteBuffer writeDate(java.util.Date value) {
        Objects.requireNonNull(value);
        TimeZone tz = this.timezone == null ? TimeZone.getDefault() : this.timezone;
        long time = value.getTime();
        int daysSinceEpoch = (int)((time + (long)tz.getOffset(time)) / Utils.MILLIS_IN_DAY);
        return this.writeUInt16(daysSinceEpoch <= 0 ? 1 : (daysSinceEpoch > 65535 ? 65535 : daysSinceEpoch));
    }

    public String readFixedString(int length) {
        return this.readFixedString(length, StandardCharsets.UTF_8);
    }

    public String readFixedString(int length, Charset charset) {
        byte[] bytes = new byte[length];
        this.readBytes(bytes);
        return new String(bytes, charset == null ? StandardCharsets.UTF_8 : charset);
    }

    public ByteBuffer writeFixedString(String value, int length) {
        return this.writeFixedString(value, length, StandardCharsets.UTF_8);
    }

    public ByteBuffer writeFixedString(String value, int length, Charset charset) {
        byte[] src = value.getBytes(charset == null ? StandardCharsets.UTF_8 : charset);
        Utils.checkArgument(src, length);
        byte[] bytes = new byte[length];
        System.arraycopy(src, 0, bytes, 0, src.length);
        return this.writeBytes(bytes);
    }

    public String readString() {
        int length = this.readUnsignedLeb128();
        byte[] bytes = new byte[length];
        this.readBytes(bytes);
        return new String(bytes, StandardCharsets.UTF_8);
    }

    public ByteBuffer writeString(String value) {
        return this.writeString(value, false);
    }

    public ByteBuffer writeString(String value, boolean normalize) {
        Objects.requireNonNull(value);
        if (normalize) {
            int len = value.length();
            StringBuilder sb = new StringBuilder(len);
            block3: for (int i = 0; i < len; ++i) {
                char ch = value.charAt(i);
                switch (ch) {
                    case '\n': 
                    case '\r': {
                        sb.append(' ');
                        continue block3;
                    }
                    default: {
                        sb.append(ch);
                    }
                }
            }
            value = sb.toString();
        }
        byte[] bytes = value.getBytes(StandardCharsets.UTF_8);
        return this.writeUnsignedLeb128(bytes.length).writeBytes(bytes);
    }

    public ByteBuffer writeDefaultValue(ColumnDefinition column, DefaultValues defaultValues) {
        switch (column.getType()) {
            case Bool: {
                this.writeInt8(defaultValues.Bool.getValue());
                break;
            }
            case Int8: {
                this.writeInt8(defaultValues.Int8.getValue());
                break;
            }
            case Int16: {
                this.writeInt16(defaultValues.Int16.getValue());
                break;
            }
            case Int32: {
                this.writeInt32(defaultValues.Int32.getValue());
                break;
            }
            case Int64: {
                this.writeInt64(defaultValues.Int64.getValue());
                break;
            }
            case Int128: {
                this.writeInt128(defaultValues.Int128.getValue());
                break;
            }
            case Int256: {
                this.writeInt256(defaultValues.Int256.getValue());
                break;
            }
            case UInt8: {
                this.writeUInt8(defaultValues.UInt8.getValue());
                break;
            }
            case UInt16: {
                this.writeUInt16(defaultValues.UInt16.getValue());
                break;
            }
            case UInt32: {
                this.writeUInt32(defaultValues.UInt32.getValue());
                break;
            }
            case UInt64: {
                this.writeUInt64(defaultValues.UInt64.getValue());
                break;
            }
            case UInt128: {
                this.writeUInt128(defaultValues.UInt128.getValue());
                break;
            }
            case UInt256: {
                this.writeUInt256(defaultValues.UInt256.getValue());
                break;
            }
            case Float32: {
                this.writeFloat32(defaultValues.Float32.getValue().floatValue());
                break;
            }
            case Float64: {
                this.writeFloat64(defaultValues.Float64.getValue());
                break;
            }
            case Date: {
                this.writeUInt16(defaultValues.Date.getValue());
                break;
            }
            case DateTime: {
                this.writeUInt32(defaultValues.Datetime.getValue());
                break;
            }
            case DateTime64: {
                this.writeUInt64(defaultValues.Datetime64.getValue());
                break;
            }
            case Decimal: {
                this.writeDecimal(defaultValues.Decimal.getValue(), column.getPrecision(), column.getScale());
                break;
            }
            case Decimal32: {
                this.writeDecimal32(defaultValues.Decimal32.getValue(), column.getScale());
                break;
            }
            case Decimal64: {
                this.writeDecimal64(defaultValues.Decimal64.getValue(), column.getScale());
                break;
            }
            case Decimal128: {
                this.writeDecimal128(defaultValues.Decimal128.getValue(), column.getScale());
                break;
            }
            case Decimal256: {
                this.writeDecimal256(defaultValues.Decimal256.getValue(), column.getScale());
                break;
            }
            case FixedStr: {
                this.writeString(defaultValues.FixedStr.getValue());
                break;
            }
            case Enum: {
                this.writeInt8(defaultValues.Enum.getValue());
                break;
            }
            case Enum8: {
                this.writeInt8(defaultValues.Enum8.getValue());
                break;
            }
            case Enum16: {
                this.writeInt16(defaultValues.Enum16.getValue());
                break;
            }
            case IPv4: {
                this.writeUInt32(defaultValues.IPv4.getValue().intValue());
                break;
            }
            case IPv6: {
                this.writeString(defaultValues.IPv6.getValue());
                break;
            }
            case Str: {
                this.writeString(defaultValues.Str.getValue());
                break;
            }
            case UUID: {
                this.writeString(defaultValues.UUID.getValue());
                break;
            }
            default: {
                this.writeString("");
            }
        }
        return this;
    }

    public Buffer unwrap() {
        return this.buffer;
    }
}

