/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.jdbcbridge.core;

import java.util.Objects;
import java.util.TimeZone;
import ru.yandex.clickhouse.jdbcbridge.core.ByteBuffer;
import ru.yandex.clickhouse.jdbcbridge.core.ColumnDefinition;
import ru.yandex.clickhouse.jdbcbridge.core.DataAccessException;
import ru.yandex.clickhouse.jdbcbridge.core.DefaultValues;
import ru.yandex.clickhouse.jdbcbridge.core.QueryParameters;
import ru.yandex.clickhouse.jdbcbridge.core.ResponseWriter;

public interface DataTableReader {
    public boolean nextRow() throws DataAccessException;

    public boolean isNull(int var1, int var2, ColumnDefinition var3) throws DataAccessException;

    public void read(int var1, int var2, ColumnDefinition var3, ByteBuffer var4) throws DataAccessException;

    default public void process(String dataSourceId, ColumnDefinition[] requestColumns, ColumnDefinition[] customColumns, ColumnDefinition[] resultColumns, DefaultValues defaultValues, TimeZone timezone, QueryParameters params, ResponseWriter writer) throws DataAccessException {
        boolean skipped;
        Objects.requireNonNull(dataSourceId);
        Objects.requireNonNull(requestColumns);
        Objects.requireNonNull(customColumns);
        Objects.requireNonNull(resultColumns);
        Objects.requireNonNull(defaultValues);
        Objects.requireNonNull(params);
        Objects.requireNonNull(writer);
        int length = requestColumns.length;
        int[][] colIndices = new int[length][2];
        for (int i = 0; i < length; ++i) {
            boolean matched = false;
            ColumnDefinition col = requestColumns[i];
            String colName = col.getName();
            if (params.showDatasourceColumn() && "datasource".equals(colName)) {
                colIndices[i] = new int[]{i, -1};
                matched = true;
                continue;
            }
            if (params.showCustomColumns()) {
                for (int k = 0; k < customColumns.length; ++k) {
                    if (!colName.equals(customColumns[k].getName())) continue;
                    colIndices[i] = new int[]{k, -2};
                    matched = true;
                    break;
                }
            }
            if (!matched) {
                for (int j = 0; j < resultColumns.length; ++j) {
                    ColumnDefinition result = resultColumns[j];
                    if (!colName.equals(result.getName())) continue;
                    colIndices[i] = new int[]{i, j};
                    matched = true;
                    break;
                }
            }
            if (matched) continue;
            StringBuilder sb = new StringBuilder();
            for (int j = 0; j < resultColumns.length; ++j) {
                sb.append(',').append('[').append(resultColumns[j].getName()).append(']');
            }
            if (sb.length() > 0) {
                sb.deleteCharAt(0);
            }
            throw new IllegalArgumentException("Unknown column [" + colName + "]! Available columns are: " + sb.toString());
        }
        int rowCount = params.isMutation() ? 0 : this.skipRows(params);
        int batchSize = params.getBatchSize();
        if (batchSize <= 0) {
            batchSize = 1;
        }
        int estimatedBufferSize = length * 4 * batchSize;
        ByteBuffer buffer = ByteBuffer.newInstance(estimatedBufferSize, timezone);
        boolean bl = skipped = rowCount > 0;
        while (skipped || this.nextRow()) {
            skipped = false;
            for (int i = 0; i < length; ++i) {
                int[] indices = colIndices[i];
                int colIndex = indices[0];
                int index = indices[1];
                if (index == -1) {
                    buffer.writeNonNull().writeString(dataSourceId);
                    continue;
                }
                if (index == -2) {
                    customColumns[colIndex].writeValueTo(buffer);
                    continue;
                }
                ColumnDefinition column = requestColumns[colIndex];
                if (column.isNullable()) {
                    if (this.isNull(rowCount, index, column)) {
                        if (params.nullAsDefault()) {
                            buffer.writeNonNull().writeDefaultValue(column, defaultValues);
                            continue;
                        }
                        buffer.writeNull();
                        continue;
                    }
                    buffer.writeNonNull();
                }
                this.read(rowCount, index, column, buffer);
            }
            if (++rowCount % batchSize != 0) continue;
            writer.write(buffer);
            buffer = ByteBuffer.newInstance(estimatedBufferSize, timezone);
        }
        if (rowCount % batchSize != 0) {
            writer.write(buffer);
        }
    }

    default public int skipRows(QueryParameters parameters) {
        int rowCount = 0;
        if (parameters == null) {
            return rowCount;
        }
        int position = parameters.getPosition();
        if (position != 0) {
            if (position < 0) {
                throw new IllegalArgumentException("Only positive position is supported!");
            }
            for (int i = 0; i < position; ++i) {
                if (this.nextRow()) {
                    ++rowCount;
                    continue;
                }
                throw new IllegalStateException("Not able to move cursor to row #" + position + "as we only got " + i);
            }
        } else {
            int offset = parameters.getOffset();
            if (offset < 0) {
                throw new IllegalArgumentException("Only positive offset is supported!");
            }
            if (offset != 0) {
                int counter = offset;
                while (this.nextRow()) {
                    ++rowCount;
                    if (--offset > 0) continue;
                }
                if (offset != 0) {
                    throw new IllegalStateException("Not able to move cursor to row #" + (counter + 1) + " as we only got " + (counter - offset));
                }
            }
        }
        return rowCount;
    }
}

