/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.jdbcbridge.impl;

import io.vertx.core.json.JsonObject;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.yandex.clickhouse.jdbcbridge.core.BaseRepository;
import ru.yandex.clickhouse.jdbcbridge.core.ExtensionManager;
import ru.yandex.clickhouse.jdbcbridge.core.ManagedEntity;
import ru.yandex.clickhouse.jdbcbridge.core.NamedDataSource;
import ru.yandex.clickhouse.jdbcbridge.core.NamedQuery;
import ru.yandex.clickhouse.jdbcbridge.core.NamedSchema;
import ru.yandex.clickhouse.jdbcbridge.core.Reloadable;
import ru.yandex.clickhouse.jdbcbridge.core.Utils;

public class JsonFileRepository<T extends ManagedEntity>
extends BaseRepository<T>
implements Reloadable {
    private static final Logger log = LoggerFactory.getLogger(JsonFileRepository.class);

    public static <T extends ManagedEntity> JsonFileRepository<T> newInstance(Object ... args) {
        if (Objects.requireNonNull(args).length < 2) {
            throw new IllegalArgumentException("In order to create a JSON file repository, you need to specify at least ExtensionManager and entity class.");
        }
        ExtensionManager manager = (ExtensionManager)Objects.requireNonNull(args[0]);
        Class entityClass = (Class)Objects.requireNonNull(args[1]);
        JsonFileRepository<T> repo = new JsonFileRepository<T>(entityClass);
        String defaultDir = entityClass.getSimpleName().toLowerCase();
        String defaultEnv = entityClass.getSimpleName().toUpperCase() + "_CONFIG_DIR";
        String defaultProp = "jdbc-bridge." + defaultDir + ".config.dir";
        if (NamedDataSource.class.equals((Object)entityClass)) {
            defaultDir = "datasources";
            defaultEnv = "DATASOURCE_CONFIG_DIR";
            defaultProp = "jdbc-bridge.datasource.config.dir";
        } else if (NamedSchema.class.equals((Object)entityClass)) {
            defaultDir = "schemas";
            defaultEnv = "SCHEMA_CONFIG_DIR";
            defaultProp = "jdbc-bridge.schema.config.dir";
        } else if (NamedQuery.class.equals((Object)entityClass)) {
            defaultDir = "queries";
            defaultEnv = "QUERY_CONFIG_DIR";
            defaultProp = "jdbc-bridge.query.config.dir";
        }
        manager.registerConfigLoader(Utils.getConfiguration(defaultDir, defaultEnv, defaultProp), repo::reload);
        return repo;
    }

    public JsonFileRepository(Class<T> clazz) {
        super(clazz);
    }

    @Override
    public void reload(JsonObject config) {
        if (config == null || config.fieldNames().size() == 0) {
            log.info("No {} configuration found", (Object)this.getEntityName());
            HashSet<String> keys = new HashSet<String>();
            for (String key : this.mappings.keySet()) {
                keys.add(key);
            }
            for (String key : keys) {
                this.remove(key);
            }
        } else {
            log.info("Loading {} configuration...", (Object)this.getEntityName());
            HashSet<String> keys = new HashSet<String>();
            for (Map.Entry entry2 : config) {
                String key = (String)entry2.getKey();
                Object value = entry2.getValue();
                if (key == null || !(value instanceof JsonObject)) continue;
                keys.add(key);
                this.update(key, (JsonObject)value);
            }
            HashSet entityIds = new HashSet();
            this.mappings.entrySet().forEach(entry -> {
                String id = (String)entry.getKey();
                ManagedEntity entity = (ManagedEntity)entry.getValue();
                if (id != null && !id.isEmpty() && entity != null && id.equals(entity.getId())) {
                    entityIds.add(id);
                }
            });
            for (String id : entityIds) {
                if (keys.contains(id)) continue;
                this.remove(id);
            }
        }
    }
}

