/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.jdbcbridge.impl;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.JDBCType;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.yandex.clickhouse.jdbcbridge.core.DataType;
import ru.yandex.clickhouse.jdbcbridge.core.DataTypeConverter;
import ru.yandex.clickhouse.jdbcbridge.core.DataTypeMapping;

public class DefaultDataTypeConverter
implements DataTypeConverter {
    private static final Logger log = LoggerFactory.getLogger(DataTypeConverter.class);
    private final DataTypeMapping[] mappings;

    public DefaultDataTypeConverter() {
        this(null);
    }

    public DefaultDataTypeConverter(List<DataTypeMapping> mappings) {
        if (mappings == null) {
            this.mappings = new DataTypeMapping[0];
        } else {
            this.mappings = new DataTypeMapping[mappings.size()];
            int index = 0;
            for (DataTypeMapping m : mappings) {
                this.mappings[index++] = m;
            }
        }
    }

    @Override
    public DataType from(JDBCType jdbcType, String typeName, int precision, int scale, boolean signed) {
        for (int i = 0; i < this.mappings.length; ++i) {
            if (!this.mappings[i].accept(jdbcType, typeName)) continue;
            return this.mappings[i].getMappedType();
        }
        DataType type = DataType.Str;
        switch (jdbcType) {
            case BIT: {
                if (precision > 128) {
                    type = DataType.Int256;
                    break;
                }
                if (precision > 64) {
                    type = DataType.Int128;
                    break;
                }
                if (precision > 32) {
                    type = DataType.Int64;
                    break;
                }
                if (precision > 16) {
                    type = DataType.Int32;
                    break;
                }
                if (precision > 8) {
                    type = DataType.Int16;
                    break;
                }
                type = DataType.Int8;
                break;
            }
            case TINYINT: {
                type = signed ? DataType.Int8 : DataType.UInt8;
                break;
            }
            case SMALLINT: {
                type = signed ? DataType.Int16 : DataType.UInt16;
                break;
            }
            case INTEGER: {
                type = signed ? DataType.Int32 : DataType.UInt32;
                break;
            }
            case BIGINT: {
                type = signed ? DataType.Int64 : DataType.UInt64;
                break;
            }
            case REAL: 
            case FLOAT: {
                type = DataType.Float32;
                break;
            }
            case DOUBLE: {
                type = DataType.Float64;
                break;
            }
            case NUMERIC: 
            case DECIMAL: {
                type = DataType.Decimal;
                break;
            }
            case ARRAY: 
            case OTHER: 
            case BOOLEAN: 
            case CHAR: 
            case NCHAR: 
            case VARCHAR: 
            case NVARCHAR: 
            case LONGVARCHAR: 
            case LONGNVARCHAR: 
            case NULL: {
                type = DataType.Str;
                break;
            }
            case DATE: {
                type = DataType.Date;
                break;
            }
            case TIME: 
            case TIMESTAMP: 
            case TIME_WITH_TIMEZONE: 
            case TIMESTAMP_WITH_TIMEZONE: {
                type = scale > 0 ? DataType.DateTime64 : DataType.DateTime;
                break;
            }
            default: {
                log.warn("Unsupported JDBC type [{}], which will be treated as [{}]", (Object)jdbcType.name(), (Object)type.name());
            }
        }
        return type;
    }

    @Override
    public DataType from(Object javaObject) {
        DataType type = javaObject == null ? DataType.Str : (javaObject instanceof Byte ? DataType.Int8 : (javaObject instanceof Short ? DataType.Int16 : (javaObject instanceof Integer ? DataType.Int32 : (javaObject instanceof Long ? DataType.Int64 : (javaObject instanceof BigInteger ? DataType.Int256 : (javaObject instanceof Float ? DataType.Float32 : (javaObject instanceof Double ? DataType.Float64 : (javaObject instanceof BigDecimal ? DataType.Decimal256 : DataType.Str))))))));
        return type;
    }
}

