/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.qatools.allure;

import ru.qatools.properties.PropertyLoader;
import ru.yandex.qatools.allure.AllureConfig;
import ru.yandex.qatools.allure.AllureConstants;
import ru.yandex.qatools.allure.AllureUtils;
import ru.yandex.qatools.allure.events.ClearStepStorageEvent;
import ru.yandex.qatools.allure.events.ClearTestStorageEvent;
import ru.yandex.qatools.allure.events.MakeAttachmentEvent;
import ru.yandex.qatools.allure.events.RemoveAttachmentsEvent;
import ru.yandex.qatools.allure.events.StepEvent;
import ru.yandex.qatools.allure.events.StepFinishedEvent;
import ru.yandex.qatools.allure.events.StepStartedEvent;
import ru.yandex.qatools.allure.events.TestCaseEvent;
import ru.yandex.qatools.allure.events.TestCaseFinishedEvent;
import ru.yandex.qatools.allure.events.TestCaseStartedEvent;
import ru.yandex.qatools.allure.events.TestSuiteEvent;
import ru.yandex.qatools.allure.events.TestSuiteFinishedEvent;
import ru.yandex.qatools.allure.experimental.LifecycleListener;
import ru.yandex.qatools.allure.experimental.ListenersNotifier;
import ru.yandex.qatools.allure.model.Attachment;
import ru.yandex.qatools.allure.model.Status;
import ru.yandex.qatools.allure.model.Step;
import ru.yandex.qatools.allure.model.TestCaseResult;
import ru.yandex.qatools.allure.model.TestSuiteResult;
import ru.yandex.qatools.allure.storages.StepStorage;
import ru.yandex.qatools.allure.storages.TestCaseStorage;
import ru.yandex.qatools.allure.storages.TestSuiteStorage;
import ru.yandex.qatools.allure.utils.AllureResultsHelper;
import ru.yandex.qatools.allure.utils.AllureShutdownHook;

public class Allure {
    public static final Allure LIFECYCLE = new Allure();
    private static final Object TEST_SUITE_ADD_CHILD_LOCK = new Object();
    private final StepStorage stepStorage;
    private final TestCaseStorage testCaseStorage;
    private final TestSuiteStorage testSuiteStorage;
    private final ListenersNotifier notifier;
    private final AllureConfig config;
    private final AllureResultsHelper resultsHelper;

    Allure() {
        this((AllureConfig)PropertyLoader.newInstance().populate(AllureConfig.class));
    }

    Allure(AllureConfig config) {
        this(config, new AllureResultsHelper(config));
    }

    Allure(AllureConfig config, AllureResultsHelper helper) {
        this.config = config;
        this.resultsHelper = helper;
        this.stepStorage = new StepStorage();
        this.testSuiteStorage = new TestSuiteStorage();
        this.testCaseStorage = new TestCaseStorage();
        this.notifier = new ListenersNotifier();
        this.init();
    }

    private void init() {
        Runtime.getRuntime().addShutdownHook(new Thread(new AllureShutdownHook(this.testSuiteStorage.getStartedSuites())));
    }

    public void fire(StepStartedEvent event) {
        Step step = new Step();
        event.process(step);
        this.stepStorage.put(step);
        this.notifier.fire(event);
    }

    public void fire(MakeAttachmentEvent event) {
        Step step = this.stepStorage.getLast();
        Attachment attachment = this.resultsHelper.writeAttachmentSafely(event.getAttachment(), event.getTitle(), event.getType());
        step.getAttachments().add(attachment);
        event.process(step);
        this.notifier.fire(event);
    }

    public void fire(RemoveAttachmentsEvent event) {
        Step step = this.stepStorage.getLast();
        this.resultsHelper.deleteAttachments(step, event.getPattern());
        event.process(step);
        this.notifier.fire(event);
    }

    public void fire(StepEvent event) {
        Step step = this.stepStorage.getLast();
        event.process(step);
        this.notifier.fire(event);
    }

    public void fire(StepFinishedEvent event) {
        Step step = this.stepStorage.adopt();
        event.process(step);
        this.notifier.fire(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fire(TestCaseStartedEvent event) {
        this.stepStorage.get();
        TestCaseResult testCase = (TestCaseResult)this.testCaseStorage.get();
        event.process(testCase);
        Object object = TEST_SUITE_ADD_CHILD_LOCK;
        synchronized (object) {
            this.testSuiteStorage.get(event.getSuiteUid()).getTestCases().add(testCase);
        }
        this.notifier.fire(event);
    }

    public void fire(TestCaseEvent event) {
        TestCaseResult testCase = (TestCaseResult)this.testCaseStorage.get();
        event.process(testCase);
        this.notifier.fire(event);
    }

    public void fire(TestCaseFinishedEvent event) {
        TestCaseResult testCase = (TestCaseResult)this.testCaseStorage.get();
        if (Status.PASSED.equals((Object)testCase.getStatus())) {
            this.fire(new RemoveAttachmentsEvent(this.config.getRemoveAttachmentsPattern()));
        }
        event.process(testCase);
        Step root = this.stepStorage.pollLast();
        testCase.getSteps().addAll(root.getSteps());
        testCase.getAttachments().addAll(root.getAttachments());
        this.stepStorage.remove();
        this.testCaseStorage.remove();
        this.notifier.fire(event);
    }

    public void fire(TestSuiteEvent event) {
        TestSuiteResult testSuite = this.testSuiteStorage.get(event.getUid());
        event.process(testSuite);
        this.notifier.fire(event);
    }

    public void fire(TestSuiteFinishedEvent event) {
        String suiteUid = event.getUid();
        TestSuiteResult testSuite = this.testSuiteStorage.remove(suiteUid);
        if (testSuite == null) {
            return;
        }
        event.process(testSuite);
        testSuite.setVersion(this.getVersion());
        testSuite.getLabels().add(AllureUtils.createProgrammingLanguageLabel());
        this.resultsHelper.writeTestSuite(testSuite);
        this.notifier.fire(event);
    }

    public void fire(ClearStepStorageEvent event) {
        this.stepStorage.remove();
        this.notifier.fire(event);
    }

    public void fire(ClearTestStorageEvent event) {
        this.testCaseStorage.remove();
        this.notifier.fire(event);
    }

    public void addListener(LifecycleListener listener) {
        this.notifier.addListener(listener);
    }

    StepStorage getStepStorage() {
        return this.stepStorage;
    }

    TestCaseStorage getTestCaseStorage() {
        return this.testCaseStorage;
    }

    TestSuiteStorage getTestSuiteStorage() {
        return this.testSuiteStorage;
    }

    public String getVersion() {
        return AllureConstants.VERSION;
    }

    public AllureConfig getConfig() {
        return this.config;
    }
}

