/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.qatools.allure.storages;

import java.util.Deque;
import java.util.LinkedList;
import ru.yandex.qatools.allure.model.Status;
import ru.yandex.qatools.allure.model.Step;

public class StepStorage
extends InheritableThreadLocal<Deque<Step>> {
    public static final Object LOCK = new Object();

    @Override
    protected Deque<Step> initialValue() {
        LinkedList<Step> queue = new LinkedList<Step>();
        queue.add(this.createRootStep());
        return queue;
    }

    @Override
    protected Deque<Step> childValue(Deque<Step> parentValue) {
        LinkedList<Step> queue = new LinkedList<Step>();
        queue.add(parentValue.getFirst());
        return queue;
    }

    public Step getLast() {
        return (Step)((Deque)this.get()).getLast();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(Step step) {
        Object object = LOCK;
        synchronized (object) {
            ((Deque)this.get()).add(step);
        }
    }

    public Step pollLast() {
        Deque queue = (Deque)this.get();
        Step last = (Step)queue.pollLast();
        if (queue.isEmpty()) {
            queue.add(this.createRootStep());
        }
        return last;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Step adopt() {
        Step step = this.pollLast();
        Object object = LOCK;
        synchronized (object) {
            this.getLast().getSteps().add(step);
        }
        return step;
    }

    public Step createRootStep() {
        return new Step().withName("Root step").withTitle("Allure step processing error: if you see this step something went wrong.").withStart(System.currentTimeMillis()).withStatus(Status.BROKEN);
    }
}

