/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.qatools.allure.utils;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ListIterator;
import java.util.regex.Pattern;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MimeTypes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.yandex.qatools.allure.AllureConfig;
import ru.yandex.qatools.allure.AllureException;
import ru.yandex.qatools.allure.AllureUtils;
import ru.yandex.qatools.allure.model.Attachment;
import ru.yandex.qatools.allure.model.Step;
import ru.yandex.qatools.allure.model.TestSuiteResult;

public class AllureResultsHelper {
    private static final Object ATTACHMENTS_LOCK = new Object();
    private static final Logger LOGGER = LoggerFactory.getLogger(AllureResultsHelper.class);
    private final AllureConfig config;
    private final Path resultsDirectory;

    public AllureResultsHelper(AllureConfig config) {
        this.config = config;
        this.resultsDirectory = AllureResultsHelper.createResultsDirectory(config);
    }

    public void deleteAttachments(Step step, Pattern pattern) {
        ListIterator iterator = step.getAttachments().listIterator();
        while (iterator.hasNext()) {
            Attachment attachment = (Attachment)iterator.next();
            if (!pattern.matcher(attachment.getSource()).matches()) continue;
            this.deleteAttachment(attachment);
            iterator.remove();
        }
        for (Step child : step.getSteps()) {
            this.deleteAttachments(child, pattern);
        }
    }

    public boolean deleteAttachment(Attachment attachment) {
        try {
            return Files.deleteIfExists(this.resultsDirectory.resolve(attachment.getSource()));
        }
        catch (IOException e) {
            LOGGER.error("Could not delete attachment file " + attachment.getSource(), (Throwable)e);
            return false;
        }
    }

    public Attachment writeAttachmentSafely(byte[] attachment, String title, String type) {
        try {
            return type == null || type.isEmpty() ? this.writeAttachment(attachment, title) : this.writeAttachment(attachment, title, type);
        }
        catch (Exception e) {
            LOGGER.trace("Error while saving attachment " + title + ":" + type, (Throwable)e);
            return this.writeAttachmentWithErrorMessage(e, title);
        }
    }

    public Attachment writeAttachmentWithErrorMessage(Throwable throwable, String title) {
        String message = throwable.getMessage();
        try {
            return this.writeAttachment(message.getBytes(this.config.getAttachmentsEncoding()), title);
        }
        catch (Exception e) {
            e.addSuppressed(throwable);
            LOGGER.error(String.format("Can't write attachment \"%s\"", title), (Throwable)e);
            return new Attachment();
        }
    }

    public Attachment writeAttachment(byte[] attachment, String title) throws IOException {
        String type = MimeTypes.getDefaultMimeTypes().detect((InputStream)new ByteArrayInputStream(attachment), new Metadata()).toString();
        return this.writeAttachment(attachment, title, type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Attachment writeAttachment(byte[] attachment, String title, String type) throws IOException {
        String name = AllureUtils.generateAttachmentName();
        String extension = AllureResultsHelper.getExtensionByMimeType(type);
        String source = name + extension;
        Path file = this.resultsDirectory.resolve(source);
        Object object = ATTACHMENTS_LOCK;
        synchronized (object) {
            if (Files.notExists(file, new LinkOption[0])) {
                Files.write(file, attachment, new OpenOption[0]);
            }
        }
        return new Attachment().withTitle(title).withSource(source).withType(type);
    }

    public void writeTestSuite(TestSuiteResult testSuite) {
        AllureUtils.marshalTestSuite((TestSuiteResult)testSuite, (Path)this.resultsDirectory.resolve(AllureUtils.generateTestSuiteXmlName()));
    }

    public static String getExtensionByMimeType(String type) {
        MimeTypes types = MimeTypes.getDefaultMimeTypes();
        try {
            return types.forName(type).getExtension();
        }
        catch (Exception e) {
            LOGGER.warn("Can't detect extension for MIME-type " + type, (Throwable)e);
            return "";
        }
    }

    private static synchronized Path createResultsDirectory(AllureConfig config) {
        Path resultsDirectory = config.getResultsDirectory();
        try {
            return Files.createDirectories(resultsDirectory, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new AllureException("Can't create results directory " + resultsDirectory, (Throwable)e);
        }
    }
}

