/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.qatools.allure.aspects;

import java.lang.reflect.Array;
import java.text.MessageFormat;
import java.util.Arrays;

public final class AllureAspectUtils {
    private AllureAspectUtils() {
    }

    public static String getName(int maxLength, String methodName, Object[] parameters) {
        if (methodName.length() > maxLength) {
            return AllureAspectUtils.cutBegin(methodName, maxLength);
        }
        return String.valueOf(methodName) + AllureAspectUtils.getParametersAsString(parameters, maxLength - methodName.length());
    }

    public static String getParametersAsString(Object[] parameters, int maxLength) {
        if (parameters == null || parameters.length == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        int i = 0;
        while (i < parameters.length) {
            builder.append(AllureAspectUtils.arrayToString(parameters[i]));
            if (i < parameters.length - 1) {
                builder.append(", ");
            }
            ++i;
        }
        return String.valueOf(AllureAspectUtils.cutEnd(builder.toString(), maxLength)) + "]";
    }

    public static String getTitle(int maxLength, String methodName, Object instance, Object[] parameters, String namePattern) {
        String finalPattern = namePattern.replaceAll("\\{method\\}", methodName).replaceAll("\\{this\\}", String.valueOf(instance));
        int paramsCount = parameters == null ? 0 : parameters.length;
        Object[] results = new Object[paramsCount];
        int i = 0;
        while (i < paramsCount) {
            results[i] = AllureAspectUtils.arrayToString(parameters[i]);
            ++i;
        }
        return AllureAspectUtils.cutEnd(MessageFormat.format(finalPattern, results), maxLength);
    }

    public static Object arrayToString(Object obj) {
        if (obj != null && obj.getClass().isArray()) {
            int len = Array.getLength(obj);
            Object[] strings = new String[len];
            int i = 0;
            while (i < len) {
                strings[i] = String.valueOf(Array.get(obj, i));
                ++i;
            }
            return Arrays.toString(strings);
        }
        return obj;
    }

    public static String cutEnd(String data, int maxLength) {
        if (data.length() > maxLength) {
            return String.valueOf(data.substring(0, maxLength)) + "...";
        }
        return data;
    }

    public static String cutBegin(String data, int maxLength) {
        if (data.length() > maxLength) {
            return "..." + data.substring(data.length() - maxLength, data.length());
        }
        return data;
    }
}

