/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.qatools.allure.aspects;

import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.NoAspectBoundException;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import ru.yandex.qatools.allure.Allure;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.aspects.AllureAspectUtils;
import ru.yandex.qatools.allure.events.StepEvent;
import ru.yandex.qatools.allure.events.StepFailureEvent;
import ru.yandex.qatools.allure.events.StepFinishedEvent;
import ru.yandex.qatools.allure.events.StepStartedEvent;

@Aspect
public class AllureStepsAspects {
    private static Allure ALLURE = Allure.LIFECYCLE;
    private static /* synthetic */ Throwable ajc$initFailureCause;
    public static final /* synthetic */ AllureStepsAspects ajc$perSingletonInstance;

    static {
        try {
            AllureStepsAspects.ajc$perSingletonInstance = new AllureStepsAspects();
        }
        catch (Throwable throwable) {
            ajc$initFailureCause = throwable;
        }
    }

    @Pointcut(value="@annotation(ru.yandex.qatools.allure.annotations.Step)")
    public /* synthetic */ void withStepAnnotation() {
    }

    @Pointcut(value="execution(* *(..))")
    public /* synthetic */ void anyMethod() {
    }

    @Before(value="anyMethod() && withStepAnnotation()")
    public void stepStart(JoinPoint joinPoint) {
        int maxLength = ALLURE.getConfig().getMaxTitleLength();
        String stepTitle = this.createTitle(joinPoint, maxLength);
        MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
        StepStartedEvent startedEvent = new StepStartedEvent(AllureAspectUtils.getName(maxLength, methodSignature.getName(), joinPoint.getArgs()));
        if (!stepTitle.isEmpty()) {
            startedEvent.setTitle(stepTitle);
        }
        ALLURE.fire(startedEvent);
    }

    @AfterThrowing(pointcut="anyMethod() && withStepAnnotation()", throwing="e")
    public void stepFailed(JoinPoint joinPoint, Throwable e) {
        ALLURE.fire((StepEvent)new StepFailureEvent().withThrowable(e));
        ALLURE.fire(new StepFinishedEvent());
    }

    @AfterReturning(pointcut="anyMethod() && withStepAnnotation()", returning="result")
    public void stepStop(JoinPoint joinPoint, Object result) {
        ALLURE.fire(new StepFinishedEvent());
    }

    public String createTitle(JoinPoint joinPoint, int maxLength) {
        MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
        Step step = methodSignature.getMethod().getAnnotation(Step.class);
        return step == null ? "" : AllureAspectUtils.getTitle(maxLength, methodSignature.getName(), joinPoint.getThis(), joinPoint.getArgs(), step.value());
    }

    static void setAllure(Allure allure) {
        ALLURE = allure;
    }

    public static AllureStepsAspects aspectOf() {
        if (ajc$perSingletonInstance == null) {
            throw new NoAspectBoundException("ru.yandex.qatools.allure.aspects.AllureStepsAspects", ajc$initFailureCause);
        }
        return ajc$perSingletonInstance;
    }

    public static boolean hasAspect() {
        return ajc$perSingletonInstance != null;
    }
}

