/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.qatools.allure;

import java.io.FilterWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import ru.yandex.qatools.allure.AllureUtils;

public class BadXmlCharacterFilterWriter
extends FilterWriter {
    public BadXmlCharacterFilterWriter(Path out) throws IOException {
        this(Files.newBufferedWriter(out, StandardCharsets.UTF_8, new OpenOption[0]));
    }

    protected BadXmlCharacterFilterWriter(Writer out) {
        super(out);
    }

    @Override
    public void write(int c) throws IOException {
        this.write(new char[]{(char)c}, 0, 1);
    }

    @Override
    public void write(String str, int off, int len) throws IOException {
        this.write(str.toCharArray(), off, len);
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        AllureUtils.replaceBadXmlCharactersBySpace(cbuf, off, len);
        super.write(cbuf, off, len);
    }
}

