/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.qatools.allure.testng;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.ISuite;
import org.testng.ISuiteListener;
import org.testng.ITestContext;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import org.testng.internal.IResultListener;
import ru.yandex.qatools.allure.Allure;
import ru.yandex.qatools.allure.AllureUtils;
import ru.yandex.qatools.allure.annotations.Parameter;
import ru.yandex.qatools.allure.events.AddParameterEvent;
import ru.yandex.qatools.allure.events.TestCaseCanceledEvent;
import ru.yandex.qatools.allure.events.TestCaseEvent;
import ru.yandex.qatools.allure.events.TestCaseFailureEvent;
import ru.yandex.qatools.allure.events.TestCaseFinishedEvent;
import ru.yandex.qatools.allure.events.TestCasePendingEvent;
import ru.yandex.qatools.allure.events.TestCaseStartedEvent;
import ru.yandex.qatools.allure.events.TestSuiteEvent;
import ru.yandex.qatools.allure.events.TestSuiteFinishedEvent;
import ru.yandex.qatools.allure.events.TestSuiteStartedEvent;
import ru.yandex.qatools.allure.model.Description;
import ru.yandex.qatools.allure.model.Label;
import ru.yandex.qatools.allure.model.ParameterKind;
import ru.yandex.qatools.allure.utils.AnnotationManager;

public class AllureTestListener
implements IResultListener,
ISuiteListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(AllureTestListener.class);
    private static final String SUITE_UID = "SUITE_UID";
    private Allure lifecycle = Allure.LIFECYCLE;
    private Set<String> startedTestNames = Collections.newSetFromMap(new ConcurrentHashMap());

    public void onStart(ISuite suite) {
    }

    public void onFinish(ISuite suite) {
    }

    public void onStart(ITestContext iTestContext) {
        this.getLifecycle().fire((TestSuiteEvent)new TestSuiteStartedEvent(this.getSuiteUid(iTestContext), this.getCurrentSuiteTitle(iTestContext)).withTitle(this.getCurrentSuiteTitle(iTestContext)).withLabels(AllureUtils.createTestFrameworkLabel((String)"TestNG"), new Label[0]));
        this.addPendingMethods(iTestContext);
    }

    public void onFinish(ITestContext iTestContext) {
        this.getLifecycle().fire(new TestSuiteFinishedEvent(this.getSuiteUid(iTestContext)));
    }

    public void onConfigurationSuccess(ITestResult iTestResult) {
    }

    public void onConfigurationFailure(ITestResult iTestResult) {
        if (this.isSuppressConfigEvent(iTestResult)) {
            return;
        }
        String suiteUid = this.getSuiteUid(iTestResult.getTestContext());
        if (this.isAfterSuiteConfigMethod(iTestResult)) {
            String suiteTitle = this.getCurrentSuiteTitle(iTestResult.getTestContext());
            this.getLifecycle().fire((TestSuiteEvent)new TestSuiteStartedEvent(suiteUid, suiteTitle).withTitle(suiteTitle));
        }
        Throwable throwable = iTestResult.getThrowable();
        this.createConfigEvent(iTestResult);
        this.getLifecycle().fire((TestCaseEvent)new TestCaseFailureEvent().withThrowable(throwable));
        this.fireFinishTest();
        if (this.isAfterSuiteConfigMethod(iTestResult)) {
            this.getLifecycle().fire(new TestSuiteFinishedEvent(suiteUid));
        }
    }

    public void onConfigurationSkip(ITestResult iTestResult) {
        if (this.isSuppressConfigEvent(iTestResult)) {
            return;
        }
        String suiteUid = this.getSuiteUid(iTestResult.getTestContext());
        if (this.isAfterSuiteConfigMethod(iTestResult)) {
            String suiteTitle = this.getCurrentSuiteTitle(iTestResult.getTestContext());
            this.getLifecycle().fire((TestSuiteEvent)new TestSuiteStartedEvent(suiteUid, suiteTitle).withTitle(suiteTitle));
        }
        this.createConfigEvent(iTestResult);
        this.fireTestCaseCancel(iTestResult);
        this.fireFinishTest();
        if (this.isAfterSuiteConfigMethod(iTestResult)) {
            this.getLifecycle().fire(new TestSuiteFinishedEvent(suiteUid));
        }
    }

    public void onTestStart(ITestResult iTestResult) {
        ITestNGMethod method = iTestResult.getMethod();
        String suitePrefix = this.getCurrentSuitePrefix(iTestResult);
        String testName = this.getName(iTestResult);
        this.startedTestNames.add(testName);
        testName = testName.replace(suitePrefix, "");
        String invoc = this.getMethodInvocationsAndSuccessPercentage(iTestResult);
        Description description = new Description().withValue(method.getDescription());
        String suiteUid = this.getSuiteUid(iTestResult.getTestContext());
        TestCaseStartedEvent event = new TestCaseStartedEvent(suiteUid, testName + invoc);
        if (description.getValue() != null) {
            event.setDescription(description);
        }
        AnnotationManager am = new AnnotationManager(this.getMethodAnnotations(iTestResult));
        am.setDefaults(this.getClassAnnotations(iTestResult));
        am.update(event);
        this.getLifecycle().fire(event);
        this.fireAddParameterEvents(iTestResult);
    }

    public void onTestSuccess(ITestResult iTestResult) {
        this.fireFinishTest();
    }

    public void onTestFailure(ITestResult iTestResult) {
        this.getLifecycle().fire((TestCaseEvent)new TestCaseFailureEvent().withThrowable(iTestResult.getThrowable()));
        this.fireFinishTest();
    }

    public void onTestFailedButWithinSuccessPercentage(ITestResult iTestResult) {
        Throwable throwable = iTestResult.getThrowable();
        this.getLifecycle().fire((TestCaseEvent)new TestCaseCanceledEvent().withThrowable(throwable));
        this.fireFinishTest();
    }

    public void onTestSkipped(ITestResult iTestResult) {
        if (!this.startedTestNames.contains(this.getName(iTestResult))) {
            this.onTestStart(iTestResult);
        }
        this.fireTestCaseCancel(iTestResult);
        this.fireFinishTest();
    }

    public Annotation[] getMethodAnnotations(ITestResult iTestResult) {
        return iTestResult.getMethod().getConstructorOrMethod().getMethod().getAnnotations();
    }

    public Annotation[] getClassAnnotations(ITestResult iTestResult) {
        if (iTestResult.getInstance() == null) {
            return new Annotation[0];
        }
        return iTestResult.getInstance().getClass().getAnnotations();
    }

    public Allure getLifecycle() {
        return this.lifecycle;
    }

    public void setLifecycle(Allure lifecycle) {
        this.lifecycle = lifecycle;
    }

    public String getSuiteUid(ITestContext iTestContext) {
        String uid;
        if (iTestContext.getAttribute(SUITE_UID) != null) {
            uid = (String)iTestContext.getAttribute(SUITE_UID);
        } else {
            uid = UUID.randomUUID().toString();
            iTestContext.setAttribute(SUITE_UID, (Object)uid);
        }
        return uid;
    }

    public String getCurrentSuiteTitle(ITestContext iTestContext) {
        String suite = iTestContext.getSuite().getName();
        String xmlTest = iTestContext.getCurrentXmlTest().getName();
        String params = "";
        if (!iTestContext.getCurrentXmlTest().getLocalParameters().isEmpty()) {
            params = iTestContext.getCurrentXmlTest().getLocalParameters().toString().replace("{", "[").replace("}", "]");
        }
        return suite + " : " + xmlTest + params;
    }

    private String getName(ITestResult iTestResult) {
        String suitePrefix = this.getCurrentSuitePrefix(iTestResult);
        StringBuilder sb = new StringBuilder(suitePrefix);
        sb.append(iTestResult.getName());
        Object[] parameters = iTestResult.getParameters();
        if (parameters != null && parameters.length > 0) {
            sb.append("[");
            for (Object parameter : parameters) {
                sb.append(parameter).append(",");
            }
            sb.replace(sb.length() - 1, sb.length(), "]");
        }
        return sb.toString();
    }

    private String getCurrentSuitePrefix(ITestResult iTestResult) {
        return "{" + this.getCurrentSuiteTitle(iTestResult.getTestContext()) + "}";
    }

    private void addPendingMethods(ITestContext iTestContext) {
        for (ITestNGMethod method : iTestContext.getExcludedMethods()) {
            if (!method.isTest() || method.getEnabled()) continue;
            Description description = new Description().withValue(method.getDescription());
            String suiteUid = this.getSuiteUid(iTestContext);
            TestCaseStartedEvent event = new TestCaseStartedEvent(suiteUid, method.getMethodName());
            if (description.getValue() != null) {
                event.setDescription(description);
            }
            Annotation[] annotations = method.getConstructorOrMethod().getMethod().getAnnotations();
            AnnotationManager am = new AnnotationManager(annotations);
            am.setDefaults(method.getInstance().getClass().getAnnotations());
            am.update(event);
            this.getLifecycle().fire(event);
            this.getLifecycle().fire((TestCaseEvent)new TestCasePendingEvent());
            this.fireFinishTest();
        }
    }

    private String getMethodInvocationsAndSuccessPercentage(ITestResult iTestResult) {
        int percentage = iTestResult.getMethod().getSuccessPercentage();
        int curCount = iTestResult.getMethod().getCurrentInvocationCount() + 1;
        int iCount = iTestResult.getMethod().getInvocationCount();
        String invoc = "";
        if (iCount > 1) {
            invoc = ":" + curCount + "/" + iCount;
            if (percentage > 0) {
                invoc = invoc + " " + percentage + "%";
            }
        }
        return invoc;
    }

    private ConfigMethodType getConfigMethodType(ITestResult iTestResult) {
        if (iTestResult.getMethod().isBeforeSuiteConfiguration()) {
            return ConfigMethodType.BEFORE_SUITE;
        }
        if (iTestResult.getMethod().isBeforeTestConfiguration()) {
            return ConfigMethodType.BEFORE_TEST;
        }
        if (iTestResult.getMethod().isBeforeClassConfiguration()) {
            return ConfigMethodType.BEFORE_CLASS;
        }
        if (iTestResult.getMethod().isBeforeGroupsConfiguration()) {
            return ConfigMethodType.BEFORE_GROUPS;
        }
        if (iTestResult.getMethod().isBeforeMethodConfiguration()) {
            return ConfigMethodType.BEFORE_METHOD;
        }
        if (iTestResult.getMethod().isAfterSuiteConfiguration()) {
            return ConfigMethodType.AFTER_SUITE;
        }
        if (iTestResult.getMethod().isAfterTestConfiguration()) {
            return ConfigMethodType.AFTER_TEST;
        }
        if (iTestResult.getMethod().isAfterClassConfiguration()) {
            return ConfigMethodType.AFTER_CLASS;
        }
        if (iTestResult.getMethod().isAfterGroupsConfiguration()) {
            return ConfigMethodType.AFTER_GROUPS;
        }
        if (iTestResult.getMethod().isAfterMethodConfiguration()) {
            return ConfigMethodType.AFTER_METHOD;
        }
        return null;
    }

    private boolean isAfterSuiteConfigMethod(ITestResult iTestResult) {
        return ConfigMethodType.AFTER_SUITE.equals((Object)this.getConfigMethodType(iTestResult));
    }

    private synchronized boolean isSuppressConfigEvent(ITestResult iTestResult) {
        String configType;
        ITestContext context = iTestResult.getTestContext();
        if (context.getAttribute(configType = this.getConfigMethodType(iTestResult).getName()) == null) {
            HashSet<String> methodNames = new HashSet<String>();
            methodNames.add(iTestResult.getName());
            context.setAttribute(configType, methodNames);
            return false;
        }
        Set methodNames = (Set)context.getAttribute(configType);
        if (!methodNames.contains(iTestResult.getName())) {
            methodNames.add(iTestResult.getName());
            return false;
        }
        return true;
    }

    private void createConfigEvent(ITestResult iTestResult) {
        String description = iTestResult.getMethod().getDescription();
        if (description == null || description.isEmpty()) {
            description = this.getConfigMethodType(iTestResult).getName();
        }
        String suiteUid = this.getSuiteUid(iTestResult.getTestContext());
        TestCaseStartedEvent event = new TestCaseStartedEvent(suiteUid, iTestResult.getName());
        event.setDescription(new Description().withValue(description));
        AnnotationManager am = new AnnotationManager(this.getMethodAnnotations(iTestResult));
        am.setDefaults(this.getClassAnnotations(iTestResult));
        am.update(event);
        this.getLifecycle().fire(event);
    }

    private void fireFinishTest() {
        this.getLifecycle().fire(new TestCaseFinishedEvent());
    }

    private void fireTestCaseCancel(ITestResult iTestResult) {
        Throwable skipMessage = new Throwable(){
            private static final long serialVersionUID = 1L;

            @Override
            public String getMessage() {
                return "Skipped due to dependency on other skipped or failed test methods";
            }
        };
        this.getLifecycle().fire((TestCaseEvent)new TestCaseCanceledEvent().withThrowable(skipMessage));
    }

    private void fireAddParameterEvents(ITestResult iTestResult) {
        Object[] parameters = iTestResult.getParameters();
        Method nativeMethod = iTestResult.getMethod().getConstructorOrMethod().getMethod();
        Annotation[][] parametersAnnotations = nativeMethod.getParameterAnnotations();
        List<String> methodParameterNames = this.getMethodParameterNamesIfAvailable(nativeMethod);
        for (int i = 0; i < parameters.length; ++i) {
            Parameter parameter = this.getParameterAnnotation(parametersAnnotations[i]);
            if (parameter == null) continue;
            String name = this.getNameForParameter(parameter.value(), methodParameterNames, i);
            String value = parameters[i].toString();
            this.getLifecycle().fire((TestCaseEvent)new AddParameterEvent(name, value, ParameterKind.ARGUMENT));
        }
    }

    private String getNameForParameter(String valueInAnnotation, List<String> methodParameterNames, int index) {
        if (!"".equals(valueInAnnotation)) {
            return valueInAnnotation;
        }
        if (index < methodParameterNames.size()) {
            return methodParameterNames.get(index);
        }
        return "arg" + index;
    }

    private Parameter getParameterAnnotation(Annotation[] annotations) {
        for (Annotation annotation : annotations) {
            if (!(annotation instanceof Parameter)) continue;
            return (Parameter)annotation;
        }
        return null;
    }

    private boolean canGetMethodParameterNames() {
        try {
            Class.forName("java.lang.reflect.Parameter", false, this.getClass().getClassLoader());
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private List<String> getMethodParameterNamesIfAvailable(Method testMethod) {
        ArrayList<String> result = new ArrayList<String>();
        if (!this.canGetMethodParameterNames()) {
            return result;
        }
        try {
            Object[] parameters;
            for (Object parameter : parameters = (Object[])testMethod.getClass().getMethod("getParameters", new Class[0]).invoke((Object)testMethod, new Object[0])) {
                result.add((String)parameter.getClass().getMethod("getName", new Class[0]).invoke(parameter, new Object[0]));
            }
            return result;
        }
        catch (Exception e) {
            String errorMessage = "Could not access parameter names via reflection. Falling back to default test method parameter names.";
            LOGGER.warn(errorMessage, (Throwable)e);
            return result;
        }
    }

    public static enum ConfigMethodType {
        BEFORE_SUITE("BeforeSuite"),
        BEFORE_TEST("BeforeTest"),
        BEFORE_CLASS("BeforeClass"),
        BEFORE_GROUPS("BeforeGroups"),
        BEFORE_METHOD("BeforeMethod"),
        AFTER_SUITE("AfterSuite"),
        AFTER_TEST("AfterTest"),
        AFTER_CLASS("AfterClass"),
        AFTER_GROUPS("AfterGroups"),
        AFTER_METHOD("AfterMethod");

        private String title;

        private ConfigMethodType(String title) {
            this.title = title;
        }

        public String getTitle() {
            return this.title;
        }

        public String getName() {
            return "@" + this.getTitle();
        }
    }
}

