/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.qatools.embed.postgresql.ext;

import de.flapdoodle.embed.process.config.store.IDownloadConfig;
import de.flapdoodle.embed.process.config.store.IPackageResolver;
import de.flapdoodle.embed.process.distribution.ArchiveType;
import de.flapdoodle.embed.process.distribution.Distribution;
import de.flapdoodle.embed.process.extract.Extractors;
import de.flapdoodle.embed.process.extract.FilesToExtract;
import de.flapdoodle.embed.process.extract.IExtractedFileSet;
import de.flapdoodle.embed.process.extract.IExtractor;
import de.flapdoodle.embed.process.extract.ITempNaming;
import de.flapdoodle.embed.process.io.directories.IDirectory;
import de.flapdoodle.embed.process.store.ArtifactStore;
import de.flapdoodle.embed.process.store.IDownloader;
import java.io.File;
import java.io.IOException;
import ru.yandex.qatools.embed.postgresql.ext.PostgresFilesToExtract;

public class PostgresArtifactStore
extends ArtifactStore {
    private IDownloadConfig _downloadConfig;
    private IDirectory _tempDirFactory;
    private ITempNaming _executableNaming;

    public PostgresArtifactStore(IDownloadConfig downloadConfig, IDirectory tempDirFactory, ITempNaming executableNaming, IDownloader downloader) {
        super(downloadConfig, tempDirFactory, executableNaming, downloader);
        this._downloadConfig = downloadConfig;
        this._tempDirFactory = tempDirFactory;
        this._executableNaming = executableNaming;
    }

    public IDirectory getTempDir() {
        return this._tempDirFactory;
    }

    private static File getArtifact(IDownloadConfig runtime, Distribution distribution) {
        File dir = PostgresArtifactStore.createOrGetBaseDir(runtime);
        File artifactFile = new File(dir, runtime.getPackageResolver().getPath(distribution));
        if (artifactFile.exists() && artifactFile.isFile()) {
            return artifactFile;
        }
        return null;
    }

    private static File createOrGetBaseDir(IDownloadConfig runtime) {
        File dir = runtime.getArtifactStorePath().asFile();
        PostgresArtifactStore.createOrCheckDir(dir);
        return dir;
    }

    private static void createOrCheckDir(File dir) {
        if (!dir.exists() && !dir.mkdirs()) {
            throw new IllegalArgumentException("Could NOT create Directory " + dir);
        }
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException("" + dir + " is not a Directory");
        }
    }

    public IExtractedFileSet extractFileSet(Distribution distribution) throws IOException {
        IPackageResolver packageResolver = this._downloadConfig.getPackageResolver();
        File artifact = PostgresArtifactStore.getArtifact(this._downloadConfig, distribution);
        ArchiveType archiveType = packageResolver.getArchiveType(distribution);
        IExtractor extractor = Extractors.getExtractor((ArchiveType)archiveType);
        return extractor.extract(this._downloadConfig, artifact, (FilesToExtract)new PostgresFilesToExtract(this._tempDirFactory, this._executableNaming, packageResolver.getFileSet(distribution)));
    }
}

