/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.qatools.embed.postgresql.ext;

import de.flapdoodle.embed.process.config.store.FileSet;
import de.flapdoodle.embed.process.config.store.FileType;
import de.flapdoodle.embed.process.extract.CommonsArchiveEntryAdapter;
import de.flapdoodle.embed.process.extract.FilesToExtract;
import de.flapdoodle.embed.process.extract.IArchiveEntry;
import de.flapdoodle.embed.process.extract.IExtractionMatch;
import de.flapdoodle.embed.process.extract.ITempNaming;
import de.flapdoodle.embed.process.io.directories.IDirectory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;

public class PostgresFilesToExtract
extends FilesToExtract {
    final FileSet fileSet;
    final IDirectory extractDir;

    public PostgresFilesToExtract(IDirectory dirFactory, ITempNaming executableNaming, FileSet fileSet) {
        super(dirFactory, executableNaming, fileSet);
        this.fileSet = fileSet;
        this.extractDir = dirFactory;
    }

    public IExtractionMatch find(final IArchiveEntry entry) {
        return new IExtractionMatch(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public File write(InputStream source, long size) throws IOException {
                boolean isSymLink = false;
                String linkName = "";
                if (entry instanceof CommonsArchiveEntryAdapter) {
                    try {
                        Field archiveEntryField = CommonsArchiveEntryAdapter.class.getDeclaredField("_entry");
                        archiveEntryField.setAccessible(true);
                        ArchiveEntry archiveEntry = (ArchiveEntry)archiveEntryField.get(entry);
                        if (archiveEntry instanceof TarArchiveEntry && (isSymLink = ((TarArchiveEntry)archiveEntry).isSymbolicLink())) {
                            linkName = ((TarArchiveEntry)archiveEntry).getLinkName();
                        }
                        archiveEntry.getSize();
                    }
                    catch (IllegalAccessException | NoSuchFieldException e) {
                        throw new RuntimeException("Check the version of de.flapdoodle.embed.process API. Has it changed?", e);
                    }
                }
                if (PostgresFilesToExtract.this.extractDir == null || PostgresFilesToExtract.this.extractDir.asFile() == null) {
                    return null;
                }
                Class<PostgresFilesToExtract> clazz = PostgresFilesToExtract.class;
                synchronized (PostgresFilesToExtract.class) {
                    String basePath = PostgresFilesToExtract.this.extractDir.asFile().getPath();
                    File outputFile = Paths.get(basePath, entry.getName()).toFile();
                    if (entry.isDirectory()) {
                        if (!outputFile.exists()) {
                            de.flapdoodle.embed.process.io.file.Files.createDir((File)outputFile);
                        }
                    } else {
                        if (!outputFile.exists()) {
                            if (isSymLink) {
                                try {
                                    Path target = outputFile.toPath().getParent().resolve(Paths.get(linkName, new String[0]));
                                    Files.createSymbolicLink(outputFile.toPath(), target, new FileAttribute[0]);
                                }
                                catch (Exception exception) {}
                            } else {
                                de.flapdoodle.embed.process.io.file.Files.write((InputStream)source, (File)outputFile);
                            }
                        }
                        if (entry.getName().matches("pgsql/bin/.+")) {
                            outputFile.setExecutable(true);
                        }
                    }
                    // ** MonitorExit[var6_5] (shouldn't be in output)
                    return outputFile;
                }
            }

            public FileType type() {
                for (FileSet.Entry matchingEntry : PostgresFilesToExtract.this.fileSet.entries()) {
                    if (!matchingEntry.matchingPattern().matcher(entry.getName()).matches()) continue;
                    return matchingEntry.type();
                }
                return FileType.Library;
            }
        };
    }

    public File generatedBaseDir() {
        return super.generatedBaseDir();
    }
}

