/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.qatools.embed.postgresql;

import de.flapdoodle.embed.process.builder.AbstractBuilder;
import de.flapdoodle.embed.process.config.IExecutableProcessConfig;
import de.flapdoodle.embed.process.config.IRuntimeConfig;
import de.flapdoodle.embed.process.config.io.ProcessOutput;
import de.flapdoodle.embed.process.distribution.Distribution;
import de.flapdoodle.embed.process.extract.IExtractedFileSet;
import de.flapdoodle.embed.process.io.IStreamProcessor;
import de.flapdoodle.embed.process.io.LoggingOutputStreamProcessor;
import de.flapdoodle.embed.process.io.directories.IDirectory;
import de.flapdoodle.embed.process.io.file.Files;
import de.flapdoodle.embed.process.io.progress.IProgressListener;
import de.flapdoodle.embed.process.io.progress.LoggingProgressListener;
import de.flapdoodle.embed.process.runtime.Executable;
import de.flapdoodle.embed.process.runtime.ProcessControl;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;
import ru.yandex.qatools.embed.postgresql.AbstractPGProcess;
import ru.yandex.qatools.embed.postgresql.Command;
import ru.yandex.qatools.embed.postgresql.PostgresExecutable;
import ru.yandex.qatools.embed.postgresql.PostgresStarter;
import ru.yandex.qatools.embed.postgresql.config.AbstractPostgresConfig;
import ru.yandex.qatools.embed.postgresql.config.DownloadConfigBuilder;
import ru.yandex.qatools.embed.postgresql.config.PostgresConfig;
import ru.yandex.qatools.embed.postgresql.config.RuntimeConfigBuilder;
import ru.yandex.qatools.embed.postgresql.ext.ArtifactStoreBuilder;
import ru.yandex.qatools.embed.postgresql.ext.LogWatchStreamProcessor;
import ru.yandex.qatools.embed.postgresql.ext.PostgresArtifactStore;

public class PostgresProcess
extends AbstractPGProcess<PostgresExecutable, PostgresProcess> {
    private static Logger logger = Logger.getLogger(PostgresProcess.class.getName());
    private final IRuntimeConfig runtimeConfig;
    boolean stopped = false;

    public PostgresProcess(Distribution distribution, PostgresConfig config, IRuntimeConfig runtimeConfig, PostgresExecutable executable) throws IOException {
        super(distribution, config, runtimeConfig, executable);
        this.runtimeConfig = runtimeConfig;
    }

    public static boolean shutdownPostgres(PostgresConfig config) {
        try {
            return PostgresProcess.runCmd(config, Command.PgCtl, "server stopped", 1000, "stop");
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Failed to stop postgres by pg_ctl!");
            return false;
        }
    }

    private static <P extends AbstractPGProcess> boolean runCmd(PostgresConfig config, Command cmd, String successOutput, int timoeut, String ... args) {
        return PostgresProcess.runCmd(config, cmd, successOutput, Collections.emptySet(), timoeut, args);
    }

    private static <P extends AbstractPGProcess> boolean runCmd(PostgresConfig config, Command cmd, String successOutput, Set<String> failOutput, long timeout, String ... args) {
        try {
            LogWatchStreamProcessor logWatch = new LogWatchStreamProcessor(successOutput, failOutput, (IStreamProcessor)new LoggingOutputStreamProcessor(logger, Level.ALL));
            RuntimeConfigBuilder rtConfigBuilder = new RuntimeConfigBuilder().defaults(cmd);
            IRuntimeConfig runtimeConfig = rtConfigBuilder.processOutput(new ProcessOutput((IStreamProcessor)logWatch, (IStreamProcessor)logWatch, (IStreamProcessor)logWatch)).artifactStore((AbstractBuilder)new ArtifactStoreBuilder().defaults(cmd).download((AbstractBuilder)new DownloadConfigBuilder().defaultsForCommand(cmd).progressListener((IProgressListener)new LoggingProgressListener(logger, Level.ALL)))).build();
            Executable exec = PostgresStarter.getCommand(cmd, runtimeConfig).prepare((IExecutableProcessConfig)new PostgresConfig(config).withArgs(args));
            AbstractPGProcess proc = (AbstractPGProcess)exec.start();
            logWatch.waitForResult(timeout);
            proc.waitFor();
            return true;
        }
        catch (IOException | InterruptedException e) {
            logger.log(Level.WARNING, e.getMessage());
            return false;
        }
    }

    protected Set<String> knownFailureMessages() {
        HashSet<String> ret = new HashSet<String>();
        ret.add("failed errno");
        ret.add("[postgres error]");
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void stopInternal() {
        PostgresProcess postgresProcess = this;
        synchronized (postgresProcess) {
            if (!this.stopped) {
                this.stopped = true;
                logger.info("trying to stop postgresql");
                if (!this.sendStopToPostgresqlInstance()) {
                    logger.warning("could not stop postgresql with command, try next");
                    if (!this.sendKillToProcess()) {
                        logger.warning("could not stop postgresql, try next");
                        if (!this.sendTermToProcess()) {
                            logger.warning("could not stop postgresql, try next");
                            if (!this.tryKillToProcess()) {
                                logger.warning("could not stop postgresql the second time, try one last thing");
                            }
                        }
                    }
                }
            }
            this.deleteTempFiles();
        }
    }

    protected final boolean sendStopToPostgresqlInstance() {
        IDirectory tempDir;
        boolean result = PostgresProcess.shutdownPostgres((PostgresConfig)this.getConfig());
        if (this.runtimeConfig.getArtifactStore() instanceof PostgresArtifactStore && (tempDir = ((PostgresArtifactStore)this.runtimeConfig.getArtifactStore()).getTempDir()) != null && tempDir.asFile() != null) {
            logger.log(Level.INFO, String.format("Cleaning up after the embedded process (removing %s)...", tempDir.asFile().getAbsolutePath()));
            Files.forceDelete((File)tempDir.asFile());
        }
        return result;
    }

    protected void onBeforeProcess(IRuntimeConfig runtimeConfig) throws IOException {
        super.onBeforeProcess(runtimeConfig);
        PostgresConfig config = (PostgresConfig)this.getConfig();
        PostgresProcess.runCmd(config, Command.InitDb, "Success. You can now start the database server using", 1000, new String[0]);
    }

    protected List<String> getCommandLine(Distribution distribution, PostgresConfig config, IExtractedFileSet exe) throws IOException {
        ArrayList<String> ret = new ArrayList<String>();
        ret.addAll(Arrays.asList(exe.executable().getAbsolutePath(), "-h", config.net().host(), "-p", String.valueOf(config.net().port()), "-D", config.storage().dbDir().getAbsolutePath()));
        return ret;
    }

    protected void deleteTempFiles() {
        AbstractPostgresConfig.Storage storage = ((PostgresConfig)this.getConfig()).storage();
        if (storage.dbDir() != null && storage.isTmpDir() && !Files.forceDelete((File)storage.dbDir())) {
            logger.warning("Could not delete temp db dir: " + storage.dbDir());
        }
    }

    protected final void onAfterProcessStart(ProcessControl process, IRuntimeConfig runtimeConfig) throws IOException {
        Path pidFilePath = Paths.get(((PostgresConfig)this.getConfig()).storage().dbDir().getAbsolutePath(), "postmaster.pid");
        File pidFile = new File(pidFilePath.toAbsolutePath().toString());
        int timeout = 20000;
        while (!pidFile.exists() && (timeout -= 100) > 0) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        int pid = -1;
        try {
            pid = Integer.valueOf((String)FileUtils.readLines((File)pidFilePath.toFile()).get(0));
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, String.format("Failed to read PID file (%s)", e.getMessage()));
        }
        if (pid != -1) {
            this.setProcessId(pid);
        } else {
            this.setProcessId(PostgresProcess.getPidFromFile((File)this.pidFile()));
        }
        PostgresProcess.runCmd((PostgresConfig)this.getConfig(), Command.CreateDb, "", new HashSet<String>(Collections.singletonList("database creation failed")), 1000L, ((PostgresConfig)this.getConfig()).storage().dbName());
    }

    public void importFromFile(File file) {
        if (file.exists()) {
            PostgresProcess.runCmd((PostgresConfig)this.getConfig(), Command.Psql, "", new HashSet<String>(Collections.singletonList("import into " + ((PostgresConfig)this.getConfig()).storage().dbName() + " failed")), 1000L, "-U", ((PostgresConfig)this.getConfig()).credentials().username(), "-d", ((PostgresConfig)this.getConfig()).storage().dbName(), "-h", ((PostgresConfig)this.getConfig()).net().host(), "-f", file.getAbsolutePath());
        }
    }

    @Override
    protected void cleanupInternal() {
    }
}

