/*
 * Decompiled with CFR 0.152.
 */
package org.osjava.scraping;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.NumberUtils;
import org.osjava.scraping.Config;

public abstract class AbstractConfig
implements Config {
    private String context = "";

    protected abstract Object getValue(String var1);

    public Object get(String key) {
        return this.getValue(this.getContext() + key);
    }

    public boolean has(String key) {
        return this.get(key) != null;
    }

    public Object getAbsolute(String key) {
        return this.getValue(key);
    }

    public String getString(String key) {
        return (String)this.get(key);
    }

    public Date getDate(String key) {
        try {
            return DateFormat.getDateInstance(3).parse(key);
        }
        catch (ParseException pe) {
            return null;
        }
    }

    public int getInt(String key) {
        return NumberUtils.stringToInt((String)this.getString(key));
    }

    public List getList(String key) {
        ArrayList obj = this.get(key);
        if (!(obj instanceof List)) {
            ArrayList list = new ArrayList(1);
            list.add(obj);
            obj = list;
        }
        return obj;
    }

    public void setContext(String context) {
        this.context = context;
    }

    public String getContext() {
        return this.context;
    }

    public Config cloneConfig() {
        try {
            return (Config)this.clone();
        }
        catch (CloneNotSupportedException cnse) {
            throw new RuntimeException("Cloning of a Config failed. This should be impossible. ");
        }
    }
}

