/*
 * Decompiled with CFR 0.152.
 */
package org.osjava.scraping;

import org.osjava.scraping.AbstractParser;
import org.osjava.scraping.Config;
import org.osjava.scraping.Header;
import org.osjava.scraping.NullResult;
import org.osjava.scraping.Page;
import org.osjava.scraping.ParsingException;
import org.osjava.scraping.Result;
import org.osjava.scraping.Session;
import org.osjava.scraping.Store;
import org.osjava.scraping.StoreFactory;
import org.osjava.scraping.StoringException;

public abstract class CheckingParser
extends AbstractParser {
    public Result parse(Page page, Config cfg, Session session) throws ParsingException {
        Header header = this.parseHeader(page, cfg, session);
        Store store = StoreFactory.getStore(cfg, session);
        try {
            boolean found = store.exists(header, cfg, session);
            if (found) {
                return new NullResult();
            }
            return this.parseBody(page, header, cfg, session);
        }
        catch (StoringException se) {
            return new NullResult();
        }
    }

    public abstract Header parseHeader(Page var1, Config var2, Session var3) throws ParsingException;

    public abstract Result parseBody(Page var1, Header var2, Config var3, Session var4) throws ParsingException;
}

