/*
 * Decompiled with CFR 0.152.
 */
package org.osjava.scraping;

import java.util.List;
import org.osjava.scraping.Config;
import org.osjava.scraping.ConfigFactory;
import org.osjava.scraping.Fetcher;
import org.osjava.scraping.FetchingException;
import org.osjava.scraping.FetchingFactory;
import org.osjava.scraping.NamespaceSession;
import org.osjava.scraping.NotificationException;
import org.osjava.scraping.NotificationFactory;
import org.osjava.scraping.Notifier;
import org.osjava.scraping.Page;
import org.osjava.scraping.Parser;
import org.osjava.scraping.ParserFactory;
import org.osjava.scraping.ParsingException;
import org.osjava.scraping.Result;
import org.osjava.scraping.Runner;
import org.osjava.scraping.Scheduler;
import org.osjava.scraping.SchedulerFactory;
import org.osjava.scraping.Session;
import org.osjava.scraping.Store;
import org.osjava.scraping.StoreFactory;
import org.osjava.scraping.StoringException;

public class Engine
implements Runner {
    public static void main(String[] args) {
        Engine engine = new Engine();
        engine.run(args);
    }

    public void run(String[] args) {
        Config cfg = ConfigFactory.getConfig(args);
        List list = cfg.getList("org.osjava.scrapers");
        int i = 0;
        while (i < list.size()) {
            String key = (String)list.get(i);
            NamespaceSession session = new NamespaceSession();
            session.put("org.osjava.scraper", key);
            cfg.setContext(key + ".");
            Scheduler scheduler = SchedulerFactory.getScheduler(cfg, session);
            scheduler.schedule(cfg, session, this);
            ++i;
        }
    }

    public void run(Config cfg, Session session) {
        try {
            Fetcher fetcher = FetchingFactory.getFetcher(cfg, session);
            String uri = cfg.getString("uri");
            Page page = fetcher.fetch(uri, cfg, session);
            Parser parser = ParserFactory.getParser(cfg, session);
            Result result = parser.parse(page, cfg, session);
            Store store = StoreFactory.getStore(cfg, session);
            store.store(result, cfg, session);
            Notifier notifier = NotificationFactory.getSuccessNotifier(cfg, session);
            notifier.notify(cfg, session);
        }
        catch (FetchingException fe) {
            Engine.notifyError(cfg, session, (Exception)((Object)fe));
        }
        catch (ParsingException pe) {
            Engine.notifyError(cfg, session, (Exception)((Object)pe));
        }
        catch (StoringException se) {
            Engine.notifyError(cfg, session, (Exception)((Object)se));
        }
        catch (NotificationException ne) {
            Engine.notifyError(cfg, session, (Exception)((Object)ne));
        }
    }

    private static void notifyError(Config cfg, Session session, Exception e) {
        try {
            Notifier notifier = NotificationFactory.getErrorNotifier(cfg, session, e);
            session.put(cfg.getContext() + ".error", e);
            notifier.notify(cfg, session);
            session.remove(cfg.getContext() + ".error");
        }
        catch (NotificationException ne) {
            ne.printStackTrace();
        }
    }
}

