/*
 * Decompiled with CFR 0.152.
 */
package org.osjava.scraping;

import com.generationjava.io.StreamW;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.osjava.scraping.Config;
import org.osjava.scraping.Header;
import org.osjava.scraping.Result;
import org.osjava.scraping.Session;
import org.osjava.scraping.Store;
import org.osjava.scraping.StoringException;

public class FileStore
implements Store {
    private static Logger logger = Logger.getLogger((Class)(class$org$osjava$scraping$FileStore == null ? (class$org$osjava$scraping$FileStore = FileStore.class$("org.osjava.scraping.FileStore")) : class$org$osjava$scraping$FileStore));
    static /* synthetic */ Class class$org$osjava$scraping$FileStore;

    public void store(Result result, Config cfg, Session session) throws StoringException {
        OutputStream out = null;
        InputStream in = null;
        try {
            String path = cfg.getString("file.path");
            String saveAs = cfg.getString("file.saveAs");
            File file = new File(path, saveAs);
            FileOutputStream fos = new FileOutputStream(file);
            Iterator iterator = result.iterateRows();
            if (iterator.hasNext()) {
                Object[] row = (Object[])iterator.next();
                if (row.length == 0) {
                    logger.error((Object)"Empty row found. Skipping. ");
                    return;
                }
                in = this.open(row[0]);
                if (in != null) {
                    StreamW.pushStream((InputStream)in, (OutputStream)fos);
                }
            }
        }
        catch (IOException ioe) {
            throw new StoringException("File I/O Storing Error: " + ioe.getMessage(), ioe);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException ioe) {}
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException ioe) {}
        }
    }

    public boolean exists(Header header, Config cfg, Session session) throws StoringException {
        return false;
    }

    private InputStream open(Object obj) throws IOException {
        if (obj instanceof URL) {
            URL url = (URL)obj;
            return url.openStream();
        }
        if (obj instanceof String) {
            return new ByteArrayInputStream(((String)obj).getBytes());
        }
        if (obj instanceof InputStream) {
            return (InputStream)obj;
        }
        if (obj instanceof File) {
            return new FileInputStream((File)obj);
        }
        if (obj instanceof byte[]) {
            return new ByteArrayInputStream((byte[])obj);
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

