/*
 * Decompiled with CFR 0.152.
 */
package org.osjava.scraping;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Iterator;
import javax.sql.DataSource;
import org.apache.commons.dbutils.DbUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.osjava.scraping.Config;
import org.osjava.scraping.Header;
import org.osjava.scraping.Result;
import org.osjava.scraping.Session;
import org.osjava.scraping.Store;
import org.osjava.scraping.StoringException;

public class JdbcStore
implements Store {
    private static Logger logger = Logger.getLogger((Class)(class$org$osjava$scraping$JdbcStore == null ? (class$org$osjava$scraping$JdbcStore = JdbcStore.class$("org.osjava.scraping.JdbcStore")) : class$org$osjava$scraping$JdbcStore));
    static /* synthetic */ Class class$org$osjava$scraping$JdbcStore;

    public void store(Result result, Config cfg, Session session) throws StoringException {
        Connection conn = null;
        try {
            try {
                String dsname = cfg.getString("jdbc.DS");
                DataSource ds = (DataSource)cfg.getAbsolute(dsname);
                conn = ds.getConnection();
                String sql = cfg.getString("jdbc.sql");
                String table = cfg.getString("jdbc.table");
                if (sql == null && table == null) {
                    throw new StoringException(cfg.getContext() + ".jdbc.sql or " + cfg.getContext() + ".jdbc.table must be specified. ");
                }
                Iterator iterator = result.iterateRows();
                while (iterator.hasNext()) {
                    Object[] row = (Object[])iterator.next();
                    if (row.length == 0) {
                        logger.error((Object)"Empty row found. Skipping. ");
                        continue;
                    }
                    if (sql == null && table != null) {
                        sql = "INSERT INTO " + table + " VALUES(?" + StringUtils.repeat((String)", ?", (int)(row.length - 1)) + ")";
                    }
                    int count = DbUtils.executeUpdate((Connection)conn, (String)sql, (Object[])row);
                }
            }
            catch (SQLException sqle) {
                throw new StoringException("JDBC Storing Error: " + sqle.getMessage(), sqle);
            }
            Object var13_13 = null;
        }
        catch (Throwable throwable) {
            Object var13_14 = null;
            DbUtils.closeQuietly(conn);
            throw throwable;
        }
        DbUtils.closeQuietly((Connection)conn);
    }

    public boolean exists(Header header, Config cfg, Session session) throws StoringException {
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

