/*
 * Decompiled with CFR 0.152.
 */
package org.osjava.scraping;

import org.osjava.scraping.Config;
import org.osjava.scraping.Notifier;
import org.osjava.scraping.Session;
import org.osjava.scraping.util.FactoryUtils;

public class NotificationFactory {
    public static Notifier getSuccessNotifier(Config cfg, Session session) {
        String name = cfg.getString("notifier.success");
        Notifier notifier = (Notifier)FactoryUtils.getObject(name, "Notifier");
        if (notifier == null) {
            throw new RuntimeException("Unable to find Success Notifier. ");
        }
        return notifier;
    }

    public static Notifier getErrorNotifier(Config cfg, Session session, Exception e) {
        Notifier notifier;
        String name = cfg.getString("notifier.error." + e.getClass().getName());
        if (name == null) {
            name = cfg.getString("notifier.error");
        }
        if ((notifier = (Notifier)FactoryUtils.getObject(name, "Notifier")) == null) {
            throw new RuntimeException("Unable to find Error Notifier. ");
        }
        return notifier;
    }
}

