/*
 * Decompiled with CFR 0.152.
 */
package org.osjava.scraping;

import java.text.ParseException;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.osjava.scraping.Config;
import org.osjava.scraping.Runner;
import org.osjava.scraping.Scheduler;
import org.osjava.scraping.Session;
import org.osjava.scraping.SimpleScheduler;
import org.quartz.CronTrigger;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.SchedulerException;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.quartz.impl.StdSchedulerFactory;

public class QuartzScheduler
implements Scheduler {
    private static Logger logger = Logger.getLogger((Class)(class$org$osjava$scraping$QuartzScheduler == null ? (class$org$osjava$scraping$QuartzScheduler = QuartzScheduler.class$("org.osjava.scraping.QuartzScheduler")) : class$org$osjava$scraping$QuartzScheduler));
    private org.quartz.Scheduler quartz;
    static /* synthetic */ Class class$org$osjava$scraping$QuartzScheduler;
    static /* synthetic */ Class class$org$osjava$scraping$QuartzJob;

    public QuartzScheduler() {
        try {
            this.quartz = new StdSchedulerFactory().getScheduler();
            this.quartz.start();
        }
        catch (SchedulerException se) {
            throw new RuntimeException("Failed to schedule job. " + (Object)((Object)se));
        }
    }

    public void schedule(Config cfg, Session session, Runner runner) {
        String schedule = (cfg = cfg.cloneConfig()).getString("schedule");
        if (StringUtils.isEmpty((String)schedule)) {
            schedule = "startup";
        }
        logger.debug((Object)("SCHEDULE: " + schedule));
        if ("startup".equalsIgnoreCase(schedule)) {
            SimpleScheduler sch = new SimpleScheduler();
            sch.schedule(cfg, session, runner);
        } else {
            try {
                String ctxt = cfg.getContext();
                String jobName = ctxt + "job";
                String jobgroup = ctxt + "group";
                JobDetail detail = new JobDetail(jobName, jobgroup, class$org$osjava$scraping$QuartzJob == null ? (class$org$osjava$scraping$QuartzJob = QuartzScheduler.class$("org.osjava.scraping.QuartzJob")) : class$org$osjava$scraping$QuartzJob);
                JobDataMap map = detail.getJobDataMap();
                map.put((Object)"cfg", (Object)cfg);
                map.put((Object)"session", (Object)session);
                map.put((Object)"runner", (Object)runner);
                CronTrigger trigger = null;
                if ("cron".equalsIgnoreCase(schedule)) {
                    CronTrigger cron;
                    String cronTxt = cfg.getString("schedule.cron");
                    logger.debug((Object)("Creating cron trigger: " + cronTxt + " for " + ctxt));
                    trigger = cron = new CronTrigger(ctxt + "crontrigger", jobgroup, jobName, jobgroup, cronTxt);
                } else {
                    int repeat = cfg.getInt("schedule.repeat");
                    if (repeat == -1) {
                        repeat = SimpleTrigger.REPEAT_INDEFINITELY;
                    }
                    int interval = cfg.getInt("schedule.interval");
                    logger.debug((Object)("Creating simple trigger: " + interval + ":" + repeat + " for " + ctxt));
                    SimpleTrigger simp = new SimpleTrigger(ctxt + "simpletrigger", jobgroup, repeat, (long)interval);
                    trigger = simp;
                }
                this.quartz.scheduleJob(detail, (Trigger)trigger);
            }
            catch (ParseException pe) {
                throw new RuntimeException("Failed to parse cron. " + pe);
            }
            catch (SchedulerException se) {
                throw new RuntimeException("Failed to schedule job. " + (Object)((Object)se));
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

