/*
 * Decompiled with CFR 0.152.
 */
package org.osjava.scraping;

import com.generationjava.config.Config;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import org.apache.commons.net.ftp.FTPClient;
import org.osjava.oscube.container.Session;
import org.osjava.scraping.Fetcher;
import org.osjava.scraping.FetchingException;
import org.osjava.scraping.MemoryPage;
import org.osjava.scraping.Page;

public class FtpFetcher
implements Fetcher {
    public Page fetch(String uri, Config cfg, Session session) throws FetchingException {
        try {
            FTPClient client = new FTPClient();
            URL url = new URL(uri);
            client.connect(url.getHost());
            String username = cfg.getString("username");
            String password = cfg.getString("password");
            if (username == null) {
                username = "anonymous";
            }
            if (password == null) {
                password = "";
            }
            client.login(username, password);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            client.retrieveFile(url.getPath(), (OutputStream)baos);
            MemoryPage page = new MemoryPage(new String(baos.toByteArray()), null);
            return page;
        }
        catch (IOException ioe) {
            throw new FetchingException("Unable to download file. ", ioe);
        }
    }
}

