/*
 * Decompiled with CFR 0.152.
 */
package org.osjava.scraping.parser;

import com.generationjava.config.Config;
import com.generationjava.scrape.HtmlScraper;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.osjava.oscube.container.Result;
import org.osjava.oscube.container.Session;
import org.osjava.oscube.container.SingleResult;
import org.osjava.scraping.AbstractParser;
import org.osjava.scraping.Page;
import org.osjava.scraping.ParsingException;

public abstract class UrlScraper
extends AbstractParser {
    public Result parse(Page page, Config cfg, Session session) throws ParsingException {
        HtmlScraper scraper = new HtmlScraper();
        try {
            scraper.scrape(page.readAsString());
        }
        catch (IOException ioe) {
            throw new ParsingException("Unable to read page. ", ioe);
        }
        String url = this.scrapeUrl(scraper);
        if (url == null) {
            throw new ParsingException("Unable to find url for : " + cfg.getContext());
        }
        try {
            if (url.indexOf("://") != -1) {
                return new SingleResult((Object)new URL(url));
            }
            if (url.startsWith("/")) {
                return new SingleResult((Object)new URL(this.toBase(new URL(page.getDocumentBase())) + url));
            }
            return new SingleResult((Object)new URL(page.getDocumentBase() + "/" + url));
        }
        catch (MalformedURLException murle) {
            throw new ParsingException("Unable to parse url: " + url, murle);
        }
    }

    protected abstract String scrapeUrl(HtmlScraper var1);

    private URL toBase(URL url) throws MalformedURLException {
        return new URL(url.getProtocol() + "://" + url.getHost() + (url.getPort() == -1 ? "" : ":" + url.getPort()) + "/");
    }
}

