/*
 * Decompiled with CFR 0.152.
 */
package org.osjava.scraping;

import com.generationjava.config.Config;
import org.apache.log4j.Logger;
import org.osjava.oscube.container.Engine;
import org.osjava.oscube.container.Result;
import org.osjava.oscube.container.Runner;
import org.osjava.oscube.container.Session;
import org.osjava.oscube.service.notify.NotificationException;
import org.osjava.oscube.service.notify.NotificationFactory;
import org.osjava.oscube.service.notify.Notifier;
import org.osjava.oscube.service.store.Store;
import org.osjava.oscube.service.store.StoreFactory;
import org.osjava.oscube.service.store.StoringException;
import org.osjava.scraping.Fetcher;
import org.osjava.scraping.FetchingException;
import org.osjava.scraping.FetchingFactory;
import org.osjava.scraping.Page;
import org.osjava.scraping.Parser;
import org.osjava.scraping.ParserFactory;
import org.osjava.scraping.ParsingException;

public class ScrapingRunner
implements Runner {
    private static Logger logger = Logger.getLogger((Class)(class$org$osjava$scraping$ScrapingRunner == null ? (class$org$osjava$scraping$ScrapingRunner = ScrapingRunner.class$("org.osjava.scraping.ScrapingRunner")) : class$org$osjava$scraping$ScrapingRunner));
    static /* synthetic */ Class class$org$osjava$scraping$ScrapingRunner;

    public static void main(String[] args) {
        Engine engine = new Engine();
        ScrapingRunner runner = new ScrapingRunner();
        engine.run((Runner)runner, args);
    }

    public void run(Config cfg, Session session) {
        logger.info((Object)("Scraping: " + cfg.getString("uri")));
        try {
            Fetcher fetcher = FetchingFactory.getFetcher(cfg, session);
            String uri = cfg.getString("uri");
            Page page = fetcher.fetch(uri, cfg, session);
            Parser parser = ParserFactory.getParser(cfg, session);
            Result result = parser.parse(page, cfg, session);
            Store store = StoreFactory.getStore((Config)cfg, (Session)session);
            store.store(result, cfg, session);
            Notifier notifier = NotificationFactory.getSuccessNotifier((Config)cfg, (Session)session);
            notifier.notify(cfg, session);
        }
        catch (FetchingException fe) {
            ScrapingRunner.notifyError(cfg, session, (Exception)((Object)fe));
        }
        catch (ParsingException pe) {
            ScrapingRunner.notifyError(cfg, session, (Exception)((Object)pe));
        }
        catch (StoringException se) {
            ScrapingRunner.notifyError(cfg, session, (Exception)((Object)se));
        }
        catch (NotificationException ne) {
            ScrapingRunner.notifyError(cfg, session, (Exception)((Object)ne));
        }
        catch (RuntimeException re) {
            ScrapingRunner.notifyError(cfg, session, re);
        }
    }

    private static void notifyError(Config cfg, Session session, Exception e) {
        try {
            Notifier notifier = NotificationFactory.getErrorNotifier((Config)cfg, (Session)session, (Exception)e);
            session.put(cfg.getContext() + ".error", (Object)e);
            notifier.notify(cfg, session);
            session.remove(cfg.getContext() + ".error");
        }
        catch (NotificationException ne) {
            ne.printStackTrace();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

