/*
 * Decompiled with CFR 0.152.
 */
package se.jiderhamn.classloader.leak.prevention;

import java.awt.Toolkit;
import java.beans.Introspector;
import java.beans.PropertyEditorManager;
import java.lang.management.ManagementFactory;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.Authenticator;
import java.net.URL;
import java.security.Provider;
import java.security.Security;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ThreadPoolExecutor;
import javax.imageio.ImageIO;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.xml.parsers.DocumentBuilderFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassLoaderLeakPreventor
implements ServletContextListener {
    public static final int THREAD_WAIT_MS_DEFAULT = 5000;
    public static final int SHUTDOWN_HOOK_WAIT_MS_DEFAULT = 10000;
    protected boolean stopThreads = true;
    protected boolean stopTimerThreads = true;
    protected boolean executeShutdownHooks = true;
    protected int threadWaitMs = 10000;
    protected int shutdownHookWaitMs = 10000;
    private boolean mayBeJBoss = false;
    protected final Field java_lang_Thread_threadLocals = this.findField(Thread.class, "threadLocals");
    protected final Field java_lang_Thread_inheritableThreadLocals = this.findField(Thread.class, "inheritableThreadLocals");
    protected final Field java_lang_ThreadLocal$ThreadLocalMap_table = this.findFieldOfClass("java.lang.ThreadLocal$ThreadLocalMap", "table");
    protected Field java_lang_ThreadLocal$ThreadLocalMap$Entry_value;

    public ClassLoaderLeakPreventor() {
        if (this.java_lang_Thread_threadLocals == null) {
            this.error("java.lang.Thread.threadLocals not found; something is seriously wrong!");
        }
        if (this.java_lang_Thread_inheritableThreadLocals == null) {
            this.error("java.lang.Thread.inheritableThreadLocals not found; something is seriously wrong!");
        }
        if (this.java_lang_ThreadLocal$ThreadLocalMap_table == null) {
            this.error("java.lang.ThreadLocal$ThreadLocalMap.table not found; something is seriously wrong!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void contextInitialized(ServletContextEvent servletContextEvent) {
        ServletContext servletContext = servletContextEvent.getServletContext();
        this.stopThreads = !"false".equals(servletContext.getInitParameter("ClassLoaderLeakPreventor.stopThreads"));
        this.stopTimerThreads = !"false".equals(servletContext.getInitParameter("ClassLoaderLeakPreventor.stopTimerThreads"));
        this.executeShutdownHooks = !"false".equals(servletContext.getInitParameter("ClassLoaderLeakPreventor.executeShutdownHooks"));
        this.threadWaitMs = ClassLoaderLeakPreventor.getIntInitParameter(servletContext, "ClassLoaderLeakPreventor.threadWaitMs", 5000);
        this.shutdownHookWaitMs = ClassLoaderLeakPreventor.getIntInitParameter(servletContext, "ClassLoaderLeakPreventor.shutdownHookWaitMs", 10000);
        this.info("Settings for " + this.getClass().getName() + " (CL: 0x" + Integer.toHexString(System.identityHashCode(this.getWebApplicationClassLoader())) + "):");
        this.info("  stopThreads = " + this.stopThreads);
        this.info("  stopTimerThreads = " + this.stopTimerThreads);
        this.info("  executeShutdownHooks = " + this.executeShutdownHooks);
        this.info("  threadWaitMs = " + this.threadWaitMs + " ms");
        this.info("  shutdownHookWaitMs = " + this.shutdownHookWaitMs + " ms");
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            this.mayBeJBoss = contextClassLoader.getResource("org/jboss") != null;
        }
        catch (Exception ex) {
            // empty catch block
        }
        this.info("Initializing context by loading some known offenders with system classloader");
        try {
            boolean isSunJRE;
            block29: {
                block28: {
                    Thread.currentThread().setContextClassLoader(ClassLoader.getSystemClassLoader());
                    Toolkit.getDefaultToolkit();
                    Security.getProviders();
                    DriverManager.getDrivers();
                    ImageIO.getCacheDirectory();
                    try {
                        Class.forName("javax.security.auth.Policy").getMethod("getPolicy", new Class[0]).invoke(null, new Object[0]);
                    }
                    catch (IllegalAccessException iaex) {
                        this.error(iaex);
                    }
                    catch (InvocationTargetException itex) {
                        this.error(itex);
                    }
                    catch (NoSuchMethodException nsmex) {
                        this.error(nsmex);
                    }
                    catch (ClassNotFoundException e) {
                        // empty catch block
                    }
                    try {
                        DocumentBuilderFactory.newInstance().newDocumentBuilder();
                    }
                    catch (Exception ex) {
                        this.error(ex);
                    }
                    try {
                        Class.forName("javax.xml.bind.DatatypeConverterImpl");
                    }
                    catch (ClassNotFoundException e) {
                        // empty catch block
                    }
                    try {
                        Class.forName("javax.security.auth.login.Configuration", true, ClassLoader.getSystemClassLoader());
                    }
                    catch (ClassNotFoundException e) {
                        // empty catch block
                    }
                    try {
                        new URL("jar:file://dummy.jar!/").openConnection().setDefaultUseCaches(false);
                    }
                    catch (Exception ex) {
                        this.error(ex);
                    }
                    isSunJRE = System.getProperty("java.vendor").startsWith("Sun");
                    try {
                        Class.forName("com.sun.jndi.ldap.LdapPoolManager");
                    }
                    catch (ClassNotFoundException cnfex) {
                        if (!isSunJRE) break block28;
                        this.error(cnfex);
                    }
                }
                try {
                    Class.forName("sun.java2d.Disposer");
                }
                catch (ClassNotFoundException cnfex) {
                    if (!isSunJRE || this.mayBeJBoss) break block29;
                    this.error(cnfex);
                }
            }
            try {
                Class<?> gcClass = Class.forName("sun.misc.GC");
                Method requestLatency = gcClass.getDeclaredMethod("requestLatency", Long.TYPE);
                requestLatency.invoke(null, 3600000L);
            }
            catch (ClassNotFoundException cnfex) {
                if (isSunJRE) {
                    this.error(cnfex);
                }
            }
            catch (NoSuchMethodException nsmex) {
                this.error(nsmex);
            }
            catch (IllegalAccessException iaex) {
                this.error(iaex);
            }
            catch (InvocationTargetException itex) {
                this.error(itex);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        boolean jvmIsShuttingDown = this.isJvmShuttingDown();
        if (jvmIsShuttingDown) {
            this.info("JVM is shutting down - skip cleanup");
            return;
        }
        this.info(this.getClass().getName() + " shutting down context by removing known leaks (CL: 0x" + Integer.toHexString(System.identityHashCode(this.getWebApplicationClassLoader())) + ")");
        Introspector.flushCaches();
        this.clearBeanELResolverCache();
        this.fixBeanValidationApiLeak();
        this.fixJsfLeak();
        this.fixGeoToolsLeak();
        this.clearIntrospectionUtilsCache();
        this.deregisterJdbcDrivers();
        this.unregisterMBeans();
        this.deregisterShutdownHooks();
        this.deregisterPropertyEditors();
        this.deregisterSecurityProviders();
        this.clearDefaultAuthenticator();
        this.deregisterRmiTargets();
        this.clearThreadLocalsOfAllThreads();
        this.stopThreads();
        this.destroyThreadGroups();
        this.unsetCachedKeepAliveTimer();
        try {
            try {
                Method clearCache16 = ResourceBundle.class.getMethod("clearCache", ClassLoader.class);
                this.debug("Since Java 1.6+ is used, we can call " + clearCache16);
                clearCache16.invoke(null, this.getWebApplicationClassLoader());
            }
            catch (NoSuchMethodException e) {
                Map cacheList = (Map)this.getStaticFieldValue(ResourceBundle.class, "cacheList");
                Iterator iter = cacheList.keySet().iterator();
                Field loaderRefField = null;
                while (iter.hasNext()) {
                    WeakReference loaderRef;
                    ClassLoader classLoader;
                    Object key = iter.next();
                    if (loaderRefField == null) {
                        loaderRefField = key.getClass().getDeclaredField("loaderRef");
                        loaderRefField.setAccessible(true);
                    }
                    if (!this.isWebAppClassLoaderOrChild(classLoader = (ClassLoader)(loaderRef = (WeakReference)loaderRefField.get(key)).get())) continue;
                    this.info("Removing ResourceBundle from cache: " + key);
                    iter.remove();
                }
            }
        }
        catch (Exception ex) {
            this.error(ex);
        }
        Class logFactory = this.findClass("org.apache.commons.logging.LogFactory");
        if (logFactory != null) {
            this.info("Releasing web app classloader from Apache Commons Logging");
            try {
                logFactory.getMethod("release", ClassLoader.class).invoke(null, this.getWebApplicationClassLoader());
            }
            catch (Exception ex) {
                this.error(ex);
            }
        }
    }

    public void deregisterJdbcDrivers() {
        ArrayList<Driver> driversToDeregister = new ArrayList<Driver>();
        Enumeration<Driver> allDrivers = DriverManager.getDrivers();
        while (allDrivers.hasMoreElements()) {
            Driver driver = allDrivers.nextElement();
            if (!this.isLoadedInWebApplication(driver)) continue;
            driversToDeregister.add(driver);
        }
        for (Driver driver : driversToDeregister) {
            try {
                this.warn("JDBC driver loaded by web app deregistered: " + driver.getClass());
                DriverManager.deregisterDriver(driver);
            }
            catch (SQLException e) {
                this.error(e);
            }
        }
    }

    protected void unregisterMBeans() {
        try {
            MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
            Set<ObjectName> allMBeanNames = mBeanServer.queryNames(new ObjectName("*:*"), null);
            for (ObjectName objectName : allMBeanNames) {
                try {
                    ClassLoader mBeanClassLoader = mBeanServer.getClassLoaderFor(objectName);
                    if (!this.isWebAppClassLoaderOrChild(mBeanClassLoader)) continue;
                    this.warn("MBean '" + objectName + "' was loaded in web application; unregistering");
                    mBeanServer.unregisterMBean(objectName);
                }
                catch (Exception e) {
                    this.error(e);
                }
            }
        }
        catch (Exception e) {
            this.error(e);
        }
    }

    protected void deregisterShutdownHooks() {
        Map shutdownHooks = (Map)this.getStaticFieldValue("java.lang.ApplicationShutdownHooks", "hooks");
        if (shutdownHooks != null) {
            for (Thread shutdownHook : new ArrayList(shutdownHooks.keySet())) {
                if (!this.isThreadInWebApplication(shutdownHook)) continue;
                this.removeShutdownHook(shutdownHook);
            }
        }
    }

    protected void removeShutdownHook(Thread shutdownHook) {
        String displayString = "'" + shutdownHook + "' of type " + shutdownHook.getClass().getName();
        this.error("Removing shutdown hook: " + displayString);
        Runtime.getRuntime().removeShutdownHook(shutdownHook);
        if (this.executeShutdownHooks) {
            this.info("Executing shutdown hook now: " + displayString);
            shutdownHook.start();
            if (this.shutdownHookWaitMs > 0) {
                try {
                    shutdownHook.join(this.shutdownHookWaitMs);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (shutdownHook.isAlive()) {
                    this.warn(shutdownHook + "still running after " + this.shutdownHookWaitMs + " ms - Stopping!");
                    shutdownHook.stop();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deregisterPropertyEditors() {
        Field registryField = this.findField(PropertyEditorManager.class, "registry");
        if (registryField == null) {
            this.error("Internal registry of " + PropertyEditorManager.class.getName() + " not found");
        } else {
            try {
                Class<PropertyEditorManager> clazz = PropertyEditorManager.class;
                synchronized (PropertyEditorManager.class) {
                    Map registry = (Map)registryField.get(null);
                    if (registry != null) {
                        HashSet toRemove = new HashSet();
                        for (Map.Entry entry : registry.entrySet()) {
                            if (!this.isLoadedByWebApplication((Class)entry.getKey()) && !this.isLoadedByWebApplication((Class)entry.getValue())) continue;
                            toRemove.add(entry.getKey());
                        }
                        for (Class clazz2 : toRemove) {
                            this.warn("Property editor for type " + clazz2 + " = " + registry.get(clazz2) + " needs to be deregistered");
                            PropertyEditorManager.registerEditor(clazz2, null);
                        }
                    }
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                }
            }
            catch (Exception e) {
                this.error(e);
            }
        }
        {
            return;
        }
    }

    protected void deregisterSecurityProviders() {
        HashSet<String> providersToRemove = new HashSet<String>();
        for (Provider provider : Security.getProviders()) {
            if (!this.isLoadedInWebApplication(provider)) continue;
            providersToRemove.add(provider.getName());
        }
        if (!providersToRemove.isEmpty()) {
            this.warn("Removing security providers loaded in web app: " + providersToRemove);
            for (String providerName : providersToRemove) {
                Security.removeProvider(providerName);
            }
        }
    }

    protected void clearDefaultAuthenticator() {
        Authenticator defaultAuthenticator = (Authenticator)this.getStaticFieldValue(Authenticator.class, "theAuthenticator");
        if (defaultAuthenticator == null || this.isLoadedInWebApplication(defaultAuthenticator)) {
            Authenticator.setDefault(null);
        }
    }

    protected void deregisterRmiTargets() {
        try {
            Class objectTableClass = this.findClass("sun.rmi.transport.ObjectTable");
            if (objectTableClass != null) {
                this.clearRmiTargetsMap((Map)this.getStaticFieldValue(objectTableClass, "objTable"));
                this.clearRmiTargetsMap((Map)this.getStaticFieldValue(objectTableClass, "implTable"));
            }
        }
        catch (Exception ex) {
            this.error(ex);
        }
    }

    protected void clearRmiTargetsMap(Map<?, ?> rmiTargetsMap) {
        try {
            Field cclField = this.findFieldOfClass("sun.rmi.transport.Target", "ccl");
            this.debug("Looping " + rmiTargetsMap.size() + " RMI Targets to find leaks");
            Iterator<?> iter = rmiTargetsMap.values().iterator();
            while (iter.hasNext()) {
                Object target = iter.next();
                ClassLoader ccl = (ClassLoader)cclField.get(target);
                if (!this.isWebAppClassLoaderOrChild(ccl)) continue;
                this.warn("Removing RMI Target: " + target);
                iter.remove();
            }
        }
        catch (Exception ex) {
            this.error(ex);
        }
    }

    protected void clearThreadLocalsOfAllThreads() {
        ClearingThreadLocalProcessor clearingThreadLocalProcessor = new ClearingThreadLocalProcessor();
        for (Thread thread : this.getAllThreads()) {
            this.forEachThreadLocalInThread(thread, clearingThreadLocalProcessor);
        }
    }

    protected void stopThreads() {
        Class workerClass = this.findClass("java.util.concurrent.ThreadPoolExecutor$Worker");
        Field targetField = this.findField(Thread.class, "target");
        for (Thread thread : this.getAllThreads()) {
            Runnable target = (Runnable)this.getFieldValue(targetField, thread);
            if (thread == Thread.currentThread() || !this.isThreadInWebApplication(thread) && !this.isLoadedInWebApplication(target)) continue;
            if (thread.getThreadGroup() != null && ("system".equals(thread.getThreadGroup().getName()) || "RMI Runtime".equals(thread.getThreadGroup().getName()))) {
                if (!"Keep-Alive-Timer".equals(thread.getName())) continue;
                thread.setContextClassLoader(this.getWebApplicationClassLoader().getParent());
                this.debug("Changed contextClassLoader of HTTP keep alive thread");
                continue;
            }
            if (!thread.isAlive()) continue;
            if ("java.util.TimerThread".equals(thread.getClass().getName())) {
                if (this.stopTimerThreads) {
                    this.warn("Stopping Timer thread running in classloader.");
                    this.stopTimerThread(thread);
                    continue;
                }
                this.info("Timer thread is running in classloader, but will not be stopped");
                continue;
            }
            if (workerClass != null && workerClass.isInstance(target)) {
                if (this.stopThreads) {
                    this.warn("Shutting down " + ThreadPoolExecutor.class.getName() + " running within the classloader.");
                    try {
                        Field workerExecutor = this.findField(workerClass, "this$0");
                        ThreadPoolExecutor executor = (ThreadPoolExecutor)this.getFieldValue(workerExecutor, target);
                        executor.shutdownNow();
                    }
                    catch (Exception ex) {
                        this.error(ex);
                    }
                } else {
                    this.info(ThreadPoolExecutor.class.getName() + " running within the classloader will not be shut down.");
                }
            }
            String displayString = "'" + thread + "' of type " + thread.getClass().getName();
            if (this.stopThreads) {
                String waitString = this.threadWaitMs > 0 ? "after " + this.threadWaitMs + " ms " : "";
                this.warn("Stopping Thread " + displayString + " running in web app " + waitString);
                if (this.threadWaitMs > 0) {
                    try {
                        thread.join(this.threadWaitMs);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
                if (!thread.isAlive()) continue;
                thread.stop();
                continue;
            }
            this.warn("Thread " + displayString + " is still running in web app");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stopTimerThread(Thread thread) {
        try {
            Field newTasksMayBeScheduled = this.findField(thread.getClass(), "newTasksMayBeScheduled");
            Object queue = this.findField(thread.getClass(), "queue").get(thread);
            Method clear = queue.getClass().getDeclaredMethod("clear", new Class[0]);
            clear.setAccessible(true);
            Object object = queue;
            synchronized (object) {
                newTasksMayBeScheduled.set(thread, false);
                clear.invoke(queue, new Object[0]);
                queue.notify();
            }
        }
        catch (Exception ex) {
            this.error(ex);
        }
    }

    public void destroyThreadGroups() {
        try {
            ThreadGroup[] allThreadGroups;
            int enumeratedGroups;
            ThreadGroup systemThreadGroup = Thread.currentThread().getThreadGroup();
            while (systemThreadGroup.getParent() != null) {
                systemThreadGroup = systemThreadGroup.getParent();
            }
            int noOfGroups = systemThreadGroup.activeGroupCount();
            while ((enumeratedGroups = systemThreadGroup.enumerate(allThreadGroups = new ThreadGroup[noOfGroups += 10])) >= noOfGroups) {
            }
            for (ThreadGroup threadGroup : allThreadGroups) {
                if (!this.isLoadedInWebApplication(threadGroup) || threadGroup.isDestroyed()) continue;
                this.warn("ThreadGroup '" + threadGroup + "' was loaded inside application, needs to be destroyed");
                int noOfThreads = threadGroup.activeCount();
                if (noOfThreads > 0) {
                    this.warn("There seems to be " + noOfThreads + " running in ThreadGroup '" + threadGroup + "'; interrupting");
                    try {
                        threadGroup.interrupt();
                    }
                    catch (Exception e) {
                        this.error(e);
                    }
                }
                try {
                    threadGroup.destroy();
                    this.info("ThreadGroup '" + threadGroup + "' successfully destroyed");
                }
                catch (Exception e) {
                    this.error(e);
                }
            }
        }
        catch (Exception ex) {
            this.error(ex);
        }
    }

    protected void unsetCachedKeepAliveTimer() {
        Thread keepAliveTimer;
        Object keepAliveCache = this.getStaticFieldValue("sun.net.www.http.HttpClient", "kac");
        if (keepAliveCache != null && (keepAliveTimer = (Thread)this.getFieldValue(keepAliveCache, "keepAliveTimer")) != null && this.isWebAppClassLoaderOrChild(keepAliveTimer.getContextClassLoader())) {
            keepAliveTimer.setContextClassLoader(this.getWebApplicationClassLoader().getParent());
            this.error("ContextClassLoader of sun.net.www.http.HttpClient cached Keep-Alive-Timer set to parent instead");
        }
    }

    protected void clearBeanELResolverCache() {
        Class beanElResolverClass = this.findClass("javax.el.BeanELResolver");
        if (beanElResolverClass != null) {
            Field propertiesField;
            boolean cleared = false;
            try {
                Method purgeBeanClasses = beanElResolverClass.getDeclaredMethod("purgeBeanClasses", ClassLoader.class);
                purgeBeanClasses.setAccessible(true);
                purgeBeanClasses.invoke(beanElResolverClass.newInstance(), this.getWebApplicationClassLoader());
                cleared = true;
            }
            catch (NoSuchMethodException e) {
            }
            catch (Exception e) {
                this.error(e);
            }
            if (!cleared && (propertiesField = this.findField(beanElResolverClass, "properties")) != null) {
                try {
                    Map properties = (Map)propertiesField.get(null);
                    properties.clear();
                }
                catch (Exception e) {
                    this.error(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fixBeanValidationApiLeak() {
        Object providersPerClassloader;
        Field offendingField;
        Class offendingClass = this.findClass("javax.validation.Validation$DefaultValidationProviderResolver");
        if (offendingClass != null && (offendingField = this.findField(offendingClass, "providersPerClassloader")) != null && (providersPerClassloader = this.getStaticFieldValue(offendingField)) instanceof Map) {
            Object t = providersPerClassloader;
            synchronized (t) {
                ((Map)providersPerClassloader).remove(this.getWebApplicationClassLoader());
            }
        }
    }

    protected void fixJsfLeak() {
        Object o = this.getStaticFieldValue("javax.faces.component.UIComponentBase", "descriptors");
        if (o instanceof WeakHashMap) {
            WeakHashMap descriptors = (WeakHashMap)o;
            HashSet<Class> toRemove = new HashSet<Class>();
            for (Object key : descriptors.keySet()) {
                if (!(key instanceof Class) || !this.isLoadedByWebApplication((Class)key)) continue;
                toRemove.add((Class)key);
            }
            if (!toRemove.isEmpty()) {
                this.info("Removing " + toRemove.size() + " classes from Mojarra descriptors cache");
                for (Class clazz : toRemove) {
                    descriptors.remove(clazz);
                }
            }
        }
    }

    protected void fixGeoToolsLeak() {
        Class weakCollectionCleanerClass = this.findClass("org.geotools.util.WeakCollectionCleaner");
        if (weakCollectionCleanerClass != null) {
            try {
                weakCollectionCleanerClass.getMethod("exit", new Class[0]).invoke(null, new Object[0]);
            }
            catch (Exception ex) {
                this.error(ex);
            }
        }
    }

    protected void clearIntrospectionUtilsCache() {
        Class modelIntrospectionUtils;
        block6: {
            Class tomcatIntrospectionUtils = this.findClass("org.apache.tomcat.util.IntrospectionUtils");
            if (tomcatIntrospectionUtils != null) {
                try {
                    tomcatIntrospectionUtils.getMethod("clear", new Class[0]).invoke(null, new Object[0]);
                }
                catch (Exception ex) {
                    if (this.mayBeJBoss) break block6;
                    this.error(ex);
                }
            }
        }
        if ((modelIntrospectionUtils = this.findClass("org.apache.commons.modeler.util.IntrospectionUtils")) != null && !this.isWebAppClassLoaderOrChild(modelIntrospectionUtils.getClassLoader())) {
            try {
                modelIntrospectionUtils.getMethod("clear", new Class[0]).invoke(null, new Object[0]);
            }
            catch (Exception ex) {
                this.warn("org.apache.commons.modeler.util.IntrospectionUtils needs to be cleared but there was an error, consider upgrading Apache Commons Modeler");
                this.error(ex);
            }
        }
    }

    protected ClassLoader getWebApplicationClassLoader() {
        return ClassLoaderLeakPreventor.class.getClassLoader();
    }

    protected boolean isLoadedInWebApplication(Object o) {
        return o != null && this.isLoadedByWebApplication(o.getClass());
    }

    protected boolean isLoadedByWebApplication(Class clazz) {
        return clazz != null && this.isWebAppClassLoaderOrChild(clazz.getClassLoader());
    }

    protected boolean isWebAppClassLoaderOrChild(ClassLoader cl) {
        ClassLoader webAppCL = this.getWebApplicationClassLoader();
        while (cl != null) {
            if (cl == webAppCL) {
                return true;
            }
            cl = cl.getParent();
        }
        return false;
    }

    protected boolean isThreadInWebApplication(Thread thread) {
        return this.isLoadedInWebApplication(thread) || this.isWebAppClassLoaderOrChild(thread.getContextClassLoader());
    }

    protected <E> E getStaticFieldValue(Class clazz, String fieldName) {
        Field staticField = this.findField(clazz, fieldName);
        return staticField != null ? (E)this.getStaticFieldValue(staticField) : null;
    }

    protected <E> E getStaticFieldValue(String className, String fieldName) {
        Field staticField = this.findFieldOfClass(className, fieldName);
        return staticField != null ? (E)this.getStaticFieldValue(staticField) : null;
    }

    protected Field findFieldOfClass(String className, String fieldName) {
        Class clazz = this.findClass(className);
        if (clazz != null) {
            return this.findField(clazz, fieldName);
        }
        return null;
    }

    protected Class findClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        catch (Exception ex) {
            this.warn(ex);
            return null;
        }
    }

    protected Field findField(Class clazz, String fieldName) {
        if (clazz == null) {
            return null;
        }
        try {
            Field field = clazz.getDeclaredField(fieldName);
            field.setAccessible(true);
            return field;
        }
        catch (NoSuchFieldException ex) {
            return null;
        }
        catch (Exception ex) {
            this.warn(ex);
            return null;
        }
    }

    protected <T> T getStaticFieldValue(Field field) {
        try {
            return (T)field.get(null);
        }
        catch (Exception ex) {
            this.warn(ex);
            return null;
        }
    }

    protected <T> T getFieldValue(Object obj, String fieldName) {
        Field field = this.findField(obj.getClass(), fieldName);
        return this.getFieldValue(field, obj);
    }

    protected <T> T getFieldValue(Field field, Object obj) {
        try {
            return (T)field.get(obj);
        }
        catch (Exception ex) {
            this.warn(ex);
            return null;
        }
    }

    protected boolean isJvmShuttingDown() {
        try {
            Thread dummy = new Thread();
            Runtime.getRuntime().removeShutdownHook(dummy);
            return false;
        }
        catch (IllegalStateException isex) {
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    protected Collection<Thread> getAllThreads() {
        ThreadGroup tg = Thread.currentThread().getThreadGroup();
        while (tg.getParent() != null) {
            tg = tg.getParent();
        }
        int guessThreadCount = tg.activeCount() + 50;
        Thread[] threads = new Thread[guessThreadCount];
        int actualThreadCount = tg.enumerate(threads);
        while (actualThreadCount == guessThreadCount) {
            threads = new Thread[guessThreadCount *= 2];
            actualThreadCount = tg.enumerate(threads);
        }
        ArrayList<Thread> output = new ArrayList<Thread>();
        for (Thread t : threads) {
            if (t == null) continue;
            output.add(t);
        }
        return output;
    }

    protected void forEachThreadLocalInCurrentThread(ThreadLocalProcessor threadLocalProcessor) {
        Thread thread = Thread.currentThread();
        this.forEachThreadLocalInThread(thread, threadLocalProcessor);
    }

    protected void forEachThreadLocalInThread(Thread thread, ThreadLocalProcessor threadLocalProcessor) {
        try {
            if (this.java_lang_Thread_threadLocals != null) {
                this.processThreadLocalMap(thread, threadLocalProcessor, this.java_lang_Thread_threadLocals.get(thread));
            }
            if (this.java_lang_Thread_inheritableThreadLocals != null) {
                this.processThreadLocalMap(thread, threadLocalProcessor, this.java_lang_Thread_inheritableThreadLocals.get(thread));
            }
        }
        catch (Exception ex) {
            this.error(ex);
        }
    }

    protected void processThreadLocalMap(Thread thread, ThreadLocalProcessor threadLocalProcessor, Object threadLocalMap) throws IllegalAccessException {
        if (threadLocalMap != null && this.java_lang_ThreadLocal$ThreadLocalMap_table != null) {
            Object[] threadLocalMapTable;
            for (Object entry : threadLocalMapTable = (Object[])this.java_lang_ThreadLocal$ThreadLocalMap_table.get(threadLocalMap)) {
                if (entry == null) continue;
                Reference reference = (Reference)entry;
                ThreadLocal threadLocal = (ThreadLocal)reference.get();
                if (this.java_lang_ThreadLocal$ThreadLocalMap$Entry_value == null) {
                    this.java_lang_ThreadLocal$ThreadLocalMap$Entry_value = this.findField(entry.getClass(), "value");
                }
                Object value = this.java_lang_ThreadLocal$ThreadLocalMap$Entry_value.get(entry);
                threadLocalProcessor.process(thread, reference, threadLocal, value);
            }
        }
    }

    protected static int getIntInitParameter(ServletContext servletContext, String parameterName, int defaultValue) {
        String parameterString = servletContext.getInitParameter(parameterName);
        if (parameterString != null && parameterString.trim().length() > 0) {
            try {
                return Integer.parseInt(parameterString);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    protected String getLogPrefix() {
        return ClassLoaderLeakPreventor.class.getSimpleName() + ": ";
    }

    protected void debug(String s) {
        System.out.println(this.getLogPrefix() + s);
    }

    protected void info(String s) {
        System.out.println(this.getLogPrefix() + s);
    }

    protected void warn(String s) {
        System.err.println(this.getLogPrefix() + s);
    }

    protected void warn(Throwable t) {
        t.printStackTrace(System.err);
    }

    protected void error(String s) {
        System.err.println(this.getLogPrefix() + s);
    }

    protected void error(Throwable t) {
        t.printStackTrace(System.err);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ClearingThreadLocalProcessor
    extends WarningThreadLocalProcessor {
        protected ClearingThreadLocalProcessor() {
        }

        @Override
        public void processFurther(Thread thread, Reference entry, ThreadLocal<?> threadLocal, Object value) {
            if (threadLocal != null && thread == Thread.currentThread()) {
                ClassLoaderLeakPreventor.this.info("  Will be remove()d");
                threadLocal.remove();
            } else {
                ClassLoaderLeakPreventor.this.info("  Will be made stale for later expunging");
                entry.clear();
                if (ClassLoaderLeakPreventor.this.java_lang_ThreadLocal$ThreadLocalMap$Entry_value == null) {
                    ClassLoaderLeakPreventor.this.java_lang_ThreadLocal$ThreadLocalMap$Entry_value = ClassLoaderLeakPreventor.this.findField(entry.getClass(), "value");
                }
                try {
                    ClassLoaderLeakPreventor.this.java_lang_ThreadLocal$ThreadLocalMap$Entry_value.set(entry, null);
                }
                catch (IllegalAccessException iaex) {
                    ClassLoaderLeakPreventor.this.error(iaex);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class WarningThreadLocalProcessor
    implements ThreadLocalProcessor {
        protected WarningThreadLocalProcessor() {
        }

        @Override
        public final void process(Thread thread, Reference entry, ThreadLocal<?> threadLocal, Object value) {
            boolean customThreadLocal = ClassLoaderLeakPreventor.this.isLoadedInWebApplication(threadLocal);
            boolean valueLoadedInWebApp = ClassLoaderLeakPreventor.this.isLoadedInWebApplication(value);
            if (customThreadLocal || valueLoadedInWebApp || value instanceof ClassLoader && ClassLoaderLeakPreventor.this.isWebAppClassLoaderOrChild((ClassLoader)value)) {
                StringBuilder message = new StringBuilder();
                if (threadLocal != null) {
                    if (customThreadLocal) {
                        message.append("Custom ");
                    }
                    message.append("ThreadLocal of type ").append(threadLocal.getClass().getName()).append(": ").append(threadLocal);
                } else {
                    message.append("Unknown ThreadLocal");
                }
                message.append(" with value ").append(value);
                if (value != null) {
                    message.append(" of type ").append(value.getClass().getName());
                    if (valueLoadedInWebApp) {
                        message.append(" that is loaded by web app");
                    }
                }
                ClassLoaderLeakPreventor.this.warn(message.toString());
                this.processFurther(thread, entry, threadLocal, value);
            }
        }

        protected void processFurther(Thread thread, Reference entry, ThreadLocal<?> threadLocal, Object value) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static interface ThreadLocalProcessor {
        public void process(Thread var1, Reference var2, ThreadLocal<?> var3, Object var4);
    }
}

