/*
 * Decompiled with CFR 0.152.
 */
package org.servicemix.components.jms;

import javax.jbi.JBIException;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.InOut;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Session;
import javax.xml.transform.TransformerException;
import org.logicblaze.lingo.jms.JmsProducer;
import org.logicblaze.lingo.jms.JmsProducerPool;
import org.servicemix.components.jms.DestinationChooser;
import org.servicemix.components.jms.JmsMarshaler;
import org.servicemix.components.util.ComponentSupport;

public class JmsInOutBinding
extends ComponentSupport
implements MessageListener {
    private JmsProducerPool producerPool;
    private DestinationChooser destinationChooser;
    private JmsMarshaler marshaler = new JmsMarshaler();

    public JmsProducerPool getProducerPool() {
        return this.producerPool;
    }

    public void setProducerPool(JmsProducerPool producerPool) {
        this.producerPool = producerPool;
    }

    public DestinationChooser getDestinationChooser() {
        return this.destinationChooser;
    }

    public void setDestinationChooser(DestinationChooser destinationChooser) {
        this.destinationChooser = destinationChooser;
    }

    public JmsMarshaler getMarshaller() {
        return this.marshaler;
    }

    public void setMarshaller(JmsMarshaler marshaler) {
        this.marshaler = marshaler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Message jmsMessage) {
        JmsProducer producer = this.producerPool.borrowProducer();
        try {
            InOut messageExchange = this.getDeliveryChannel().createExchangeFactory().createInOutExchange();
            NormalizedMessage inMessage = messageExchange.createMessage();
            try {
                this.marshaler.toNMS(inMessage, jmsMessage);
                messageExchange.setInMessage(inMessage);
                if (this.getDeliveryChannel().sendSync((MessageExchange)messageExchange)) {
                    Session session = producer.getSession();
                    Destination destination = this.destinationChooser.chooseDestination((MessageExchange)messageExchange);
                    Message message = this.marshaler.createMessage(messageExchange.getOutMessage(), session);
                    producer.getMessageProducer().send(destination, message);
                }
            }
            catch (JMSException e) {
                messageExchange.setError((Exception)((Object)e));
                messageExchange.setStatus(ExchangeStatus.ERROR);
            }
            catch (TransformerException e) {
                messageExchange.setError((Exception)e);
                messageExchange.setStatus(ExchangeStatus.ERROR);
            }
        }
        catch (MessagingException messagingException) {
        }
        finally {
            this.producerPool.returnProducer(producer);
        }
    }

    public void shutDown() throws JBIException {
    }

    public void start() throws JBIException {
    }

    public void stop() throws JBIException {
    }
}

