/*
 * Decompiled with CFR 0.152.
 */
package org.servicemix.components.mule;

import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Iterator;
import javax.jbi.messaging.NormalizedMessage;
import org.mule.providers.AbstractMessageAdapter;
import org.mule.umo.MessagingException;
import org.mule.umo.provider.MessageTypeNotSupportedException;

public class JBIMessageAdapter
extends AbstractMessageAdapter {
    private NormalizedMessage message;

    public JBIMessageAdapter(Object object) throws MessagingException {
        this.setMessage(object);
    }

    public String getPayloadAsString() throws Exception {
        return this.message != null ? this.message.toString() : null;
    }

    public byte[] getPayloadAsBytes() throws Exception {
        byte[] result = null;
        if (this.message != null && this.message instanceof Serializable) {
            ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
            ObjectOutputStream objOut = new ObjectOutputStream(bytesOut);
            objOut.writeObject(this.message);
            objOut.flush();
            bytesOut.flush();
            result = bytesOut.toByteArray();
        }
        return result;
    }

    public Object getPayload() {
        return this.message;
    }

    public void setMessage(Object object) throws MessagingException {
        if (object == null || !(object instanceof NormalizedMessage)) {
            throw new MessageTypeNotSupportedException(object, ((Object)((Object)this)).getClass());
        }
        this.message = (NormalizedMessage)object;
        Iterator i = this.message.getPropertyNames().iterator();
        while (i.hasNext()) {
            String name = i.next().toString();
            this.properties.put(name, this.message.getProperty(name));
        }
    }
}

