/*
 * Decompiled with CFR 0.152.
 */
package org.servicemix.components.mule;

import javax.jbi.JBIException;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import org.mule.umo.UMOException;
import org.mule.umo.UMOMessage;
import org.servicemix.components.mule.JBIMessageReceiver;
import org.servicemix.components.mule.MuleMarshaler;
import org.servicemix.components.mule.MuleMessagingException;
import org.servicemix.components.util.OutBinding;

public class JBIMessageReceiverComponent
extends OutBinding {
    private JBIMessageReceiver receiver;
    private MuleMarshaler marshaler = new MuleMarshaler();

    public MuleMarshaler getMarshaler() {
        return this.marshaler;
    }

    public void setMarshaler(MuleMarshaler marshaler) {
        this.marshaler = marshaler;
    }

    public JBIMessageReceiver getReceiver() {
        return this.receiver;
    }

    public void setReceiver(JBIMessageReceiver receiver) {
        this.receiver = receiver;
    }

    protected void process(MessageExchange exchange, NormalizedMessage message) throws MessagingException {
        try {
            UMOMessage umoMessage = this.getMarshaler().createMuleMessage(exchange, message, this.getBody(message));
            this.receiver.routeMessage(umoMessage);
            this.done(exchange);
        }
        catch (UMOException e) {
            throw new MuleMessagingException(e);
        }
    }

    protected void init() throws JBIException {
        super.init();
        if (this.getReceiver() == null) {
            throw new JBIException("You must specify the receiver property");
        }
    }
}

