/*
 * Decompiled with CFR 0.152.
 */
package org.servicemix.components.xbean;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jbi.JBIException;
import javax.jbi.component.ComponentContext;
import javax.jbi.management.DeploymentException;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.xml.namespace.QName;
import org.servicemix.components.AbstractComponent;
import org.servicemix.components.ServiceUnit;
import org.servicemix.components.xbean.EndpointSpec;
import org.xbean.kernel.Kernel;
import org.xbean.kernel.KernelFactory;
import org.xbean.kernel.ServiceName;
import org.xbean.server.repository.FileSystemRepository;
import org.xbean.server.repository.Repository;
import org.xbean.server.spring.configuration.ClassLoaderXmlPreprocessor;
import org.xbean.server.spring.loader.SpringLoader;

public class XBeanServiceUnit
extends ServiceUnit {
    private Kernel kernel;
    protected ComponentContext context;
    protected AbstractComponent component;
    protected List services;
    protected Map endpoints = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XBeanServiceUnit(AbstractComponent component, String serviceUnitName, String serviceUnitRootPath) throws Exception {
        this.component = component;
        this.context = component.getContext();
        this.setName(serviceUnitName);
        this.setRootPath(serviceUnitRootPath);
        this.kernel = KernelFactory.newInstance().createKernel(serviceUnitName);
        boolean loaded = false;
        try {
            FileSystemRepository repository = new FileSystemRepository(new File(this.getRootPath()));
            ClassLoaderXmlPreprocessor classLoaderXmlPreprocessor = new ClassLoaderXmlPreprocessor((Repository)repository);
            List<ClassLoaderXmlPreprocessor> xmlPreprocessors = Collections.singletonList(classLoaderXmlPreprocessor);
            SpringLoader springLoader = new SpringLoader();
            springLoader.setKernel(this.kernel);
            springLoader.setBaseDir(new File(this.getRootPath()));
            springLoader.setXmlPreprocessors(xmlPreprocessors);
            ServiceName configurationName = springLoader.load("xbean");
            this.kernel.startService(configurationName);
            this.services = this.kernel.getServices(EndpointSpec.class);
            if (this.services == null || this.services.size() == 0) {
                throw new DeploymentException("no endpoints specified");
            }
            loaded = true;
        }
        finally {
            if (!loaded) {
                this.kernel.destroy();
            }
        }
    }

    public void start() throws JBIException {
        super.start();
        Iterator iter = this.services.iterator();
        while (iter.hasNext()) {
            EndpointSpec es = (EndpointSpec)iter.next();
            ServiceEndpoint ep = this.context.activateEndpoint(es.getServiceName(), es.getEndpointName());
            this.endpoints.put(this.getKey(es), ep);
        }
    }

    public void stop() throws JBIException {
        Iterator iter = this.services.iterator();
        while (iter.hasNext()) {
            EndpointSpec es = (EndpointSpec)iter.next();
            this.context.deactivateEndpoint(this.context.getEndpoint(es.getServiceName(), es.getEndpointName()));
        }
        super.stop();
    }

    public void shutDown() throws JBIException {
        this.kernel.destroy();
        super.shutDown();
    }

    public List getServices() {
        return this.services;
    }

    protected String getKey(QName service, String endpoint) {
        return service.toString() + "|" + endpoint;
    }

    protected String getKey(ServiceEndpoint ep) {
        return this.getKey(ep.getServiceName(), ep.getEndpointName());
    }

    protected String getKey(EndpointSpec es) {
        return this.getKey(es.getServiceName(), es.getEndpointName());
    }
}

