/*
 * Decompiled with CFR 0.152.
 */
package org.servicemix.components.cache;

import java.util.Map;
import javax.jbi.JBIException;
import javax.jbi.messaging.Fault;
import javax.jbi.messaging.InOut;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import org.servicemix.components.util.TransformComponentSupport;
import org.servicemix.expression.Expression;
import org.servicemix.expression.PropertyExpression;
import org.servicemix.jbi.NoOutMessageAvailableException;

public class CacheComponent
extends TransformComponentSupport {
    public static final PropertyExpression KEY_PROPERTY_EXPRESSION = new PropertyExpression("org.servicemix.key");
    private Map cache;
    private Expression keyExpression = KEY_PROPERTY_EXPRESSION;

    public Map getCache() {
        return this.cache;
    }

    public void setCache(Map cache) {
        this.cache = cache;
    }

    public Expression getKeyExpression() {
        return this.keyExpression;
    }

    public void setKeyExpression(Expression keyExpression) {
        this.keyExpression = keyExpression;
    }

    protected void init() throws JBIException {
        super.init();
        if (this.cache == null) {
            throw new JBIException("You must specify a cache property");
        }
    }

    protected boolean transform(MessageExchange exchange, NormalizedMessage in, NormalizedMessage out) throws MessagingException {
        NormalizedMessage message;
        Object key = this.keyExpression.evaluate(exchange, in);
        if (key != null && (message = (NormalizedMessage)this.cache.get(key)) != null) {
            this.getMessageTransformer().transform(exchange, message, out);
            return true;
        }
        InOut inOut = this.getExchangeFactory().createInOutExchange();
        NormalizedMessage request = inOut.createMessage();
        this.getMessageTransformer().transform(exchange, in, request);
        inOut.setInMessage(request);
        this.getDeliveryChannel().sendSync((MessageExchange)inOut);
        NormalizedMessage response = inOut.getOutMessage();
        Fault fault = inOut.getFault();
        Exception error = inOut.getError();
        if (fault != null) {
            this.fail(exchange, fault);
        } else if (error != null) {
            this.fail(exchange, error);
        } else if (response != null) {
            this.getMessageTransformer().transform(exchange, response, out);
            if (key != null) {
                this.cache.put(key, response);
            }
        } else {
            throw new NoOutMessageAvailableException(exchange);
        }
        return true;
    }
}

