/*
 * Decompiled with CFR 0.152.
 */
package org.servicemix.components.drools.dsl;

import java.util.Iterator;
import java.util.List;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import org.drools.WorkingMemory;
import org.drools.rule.Declaration;
import org.drools.rule.Rule;
import org.drools.spi.Condition;
import org.drools.spi.Tuple;
import org.servicemix.expression.JaxenVariableContext;
import org.servicemix.expression.JaxenXPathExpression;

public class JaxenCondition
implements Condition {
    private Rule rule;
    private JaxenXPathExpression expression;

    public JaxenCondition(Rule rule, JaxenXPathExpression expression) {
        this.rule = rule;
        this.expression = expression;
    }

    public Declaration[] getRequiredTupleMembers() {
        List list = this.rule.getParameterDeclarations();
        Declaration[] answer = new Declaration[list.size()];
        list.toArray(answer);
        return answer;
    }

    public boolean isAllowed(Tuple tuple) {
        List list = this.rule.getParameterDeclarations();
        WorkingMemory memory = tuple.getWorkingMemory();
        JaxenVariableContext variableContext = this.expression.getVariableContext();
        variableContext.setVariables(null);
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            Declaration declaration = (Declaration)iter.next();
            String name = declaration.getIdentifier();
            Object value = tuple.get(declaration);
            variableContext.setVariableValue(name, value);
        }
        NormalizedMessage message = (NormalizedMessage)this.findFirst(memory, NormalizedMessage.class);
        MessageExchange exchange = (MessageExchange)this.findFirst(memory, MessageExchange.class);
        try {
            return this.expression.matches(exchange, message);
        }
        catch (MessagingException e) {
            throw new RuntimeException(e);
        }
    }

    protected Object findFirst(WorkingMemory memory, Class type) {
        List objects = memory.getObjects(type);
        Object answer = null;
        if (objects.size() > 0) {
            answer = objects.get(0);
        }
        return answer;
    }
}

